/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.vault;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.security.GeneralSecurityException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VaultPKIConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultPKIConnector.class);
    long timeoutMilliSec = 1000L;
    private final CSRUtil csrUtil;
    private final CertificateUtil certUtil;
    private final ProtectedContentUtil protUtil;
    private final CertificateRepository certificateRepository;

    public VaultPKIConnector(CSRUtil csrUtil, CertificateUtil certUtil, ProtectedContentUtil protUtil, CertificateRepository certificateRepository) {
        this.csrUtil = csrUtil;
        this.certUtil = certUtil;
        this.protUtil = protUtil;
        this.certificateRepository = certificateRepository;
    }

    public Certificate signCertificateRequest(CSR csr, CAConnectorConfig caConnConfig) throws GeneralSecurityException {
        LOGGER.debug("DISABLED csr contains #{} CsrAttributes, #{} RequestAttributes and #{} RDN", new Object[]{csr.getCsrAttributes().size(), csr.getRas().size(), csr.getRdns().size()});
        return null;
    }

    private Certificate handleCertificate(String certBase64, boolean reimport) throws GeneralSecurityException {
        if (certBase64 == null || certBase64.isEmpty()) {
            return null;
        }
        byte[] certificateBytes = Base64.getDecoder().decode(certBase64);
        Certificate certDao = this.certUtil.createCertificate(certificateBytes, null, null, true);
        this.certificateRepository.save((Object)certDao);
        LOGGER.debug("Additional cert '" + certDao.getSubject() + "' from CMP response");
        return certDao;
    }
}

