/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtil.class);
    @Autowired
    private CAConnectorConfigRepository caccRepo;

    public CAConnectorConfig getDefaultConfig() {
        CAConnectorConfig caConfigDefault = null;
        for (CAConnectorConfig caConfig : this.caccRepo.findAll()) {
            LOG.debug("checking CA configuration {}, default {}", (Object)caConfig.getName(), (Object)caConfig.isDefaultCA());
            if (!caConfig.isDefaultCA().booleanValue() || !caConfig.isActive().booleanValue()) continue;
            caConfigDefault = caConfig;
            LOG.debug("default CA configuration {}, default {}", (Object)caConfig.getName(), (Object)caConfig.isDefaultCA());
            break;
        }
        if (caConfigDefault == null) {
            LOG.error("no default and active CA configured");
        }
        return caConfigDefault;
    }
}

