/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.service.util.ReplacementCandidateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CertificateAsyncUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateAsyncUtil.class);
    private final ReplacementCandidateUtil replacementCandidateUtil;

    public CertificateAsyncUtil(ReplacementCandidateUtil replacementCandidateUtil) {
        this.replacementCandidateUtil = replacementCandidateUtil;
    }

    @Async
    @Transactional
    public void onChange(Certificate certificate, List<String> emailList) {
        LOG.debug("Async call to onChange( '{}')", (Object)certificate);
        if (certificate == null) {
            return;
        }
        this.replacementCandidateUtil.notifyOnExcessiveActiveCertificates(certificate, emailList);
    }
}

