/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.RDNAttribute;
import de.trustable.ca3s.core.repository.RDNAttributeRepository;
import de.trustable.ca3s.core.service.RDNAttributeService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RDNAttributeServiceImpl
implements RDNAttributeService {
    private final Logger log = LoggerFactory.getLogger(RDNAttributeServiceImpl.class);
    private final RDNAttributeRepository rDNAttributeRepository;

    public RDNAttributeServiceImpl(RDNAttributeRepository rDNAttributeRepository) {
        this.rDNAttributeRepository = rDNAttributeRepository;
    }

    public RDNAttribute save(RDNAttribute rDNAttribute) {
        this.log.debug("Request to save RDNAttribute : {}", (Object)rDNAttribute);
        return (RDNAttribute)this.rDNAttributeRepository.save((Object)rDNAttribute);
    }

    @Transactional(readOnly=true)
    public List<RDNAttribute> findAll() {
        this.log.debug("Request to get all RDNAttributes");
        return this.rDNAttributeRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<RDNAttribute> findOne(Long id) {
        this.log.debug("Request to get RDNAttribute : {}", (Object)id);
        return this.rDNAttributeRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete RDNAttribute : {}", (Object)id);
        this.rDNAttributeRepository.deleteById((Object)id);
    }
}

