/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.PipelineAttribute;
import de.trustable.ca3s.core.repository.PipelineAttributeRepository;
import de.trustable.ca3s.core.service.PipelineAttributeService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PipelineAttributeServiceImpl
implements PipelineAttributeService {
    private final Logger log = LoggerFactory.getLogger(PipelineAttributeServiceImpl.class);
    private final PipelineAttributeRepository pipelineAttributeRepository;

    public PipelineAttributeServiceImpl(PipelineAttributeRepository pipelineAttributeRepository) {
        this.pipelineAttributeRepository = pipelineAttributeRepository;
    }

    public PipelineAttribute save(PipelineAttribute pipelineAttribute) {
        this.log.debug("Request to save PipelineAttribute : {}", (Object)pipelineAttribute);
        return (PipelineAttribute)this.pipelineAttributeRepository.save((Object)pipelineAttribute);
    }

    @Transactional(readOnly=true)
    public List<PipelineAttribute> findAll() {
        this.log.debug("Request to get all PipelineAttributes");
        return this.pipelineAttributeRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<PipelineAttribute> findOne(Long id) {
        this.log.debug("Request to get PipelineAttribute : {}", (Object)id);
        return this.pipelineAttributeRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete PipelineAttribute : {}", (Object)id);
        this.pipelineAttributeRepository.deleteById((Object)id);
    }
}

