/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.AcmeIdentifier;
import de.trustable.ca3s.core.repository.AcmeIdentifierRepository;
import de.trustable.ca3s.core.service.AcmeIdentifierService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AcmeIdentifierServiceImpl
implements AcmeIdentifierService {
    private final Logger log = LoggerFactory.getLogger(AcmeIdentifierServiceImpl.class);
    private final AcmeIdentifierRepository acmeIdentifierRepository;

    public AcmeIdentifierServiceImpl(AcmeIdentifierRepository acmeIdentifierRepository) {
        this.acmeIdentifierRepository = acmeIdentifierRepository;
    }

    public AcmeIdentifier save(AcmeIdentifier acmeIdentifier) {
        this.log.debug("Request to save AcmeIdentifier : {}", (Object)acmeIdentifier);
        return (AcmeIdentifier)this.acmeIdentifierRepository.save((Object)acmeIdentifier);
    }

    @Transactional(readOnly=true)
    public List<AcmeIdentifier> findAll() {
        this.log.debug("Request to get all AcmeIdentifiers");
        return this.acmeIdentifierRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<AcmeIdentifier> findOne(Long id) {
        this.log.debug("Request to get AcmeIdentifier : {}", (Object)id);
        return this.acmeIdentifierRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AcmeIdentifier : {}", (Object)id);
        this.acmeIdentifierRepository.deleteById((Object)id);
    }
}

