/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dir;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.ImportedURL;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.ImportedURLRepository;
import de.trustable.ca3s.core.schedule.ImportInfo;
import de.trustable.ca3s.core.schedule.spider.Crawler;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dir.DirectoryConnector;
import de.trustable.ca3s.core.service.dto.CAStatus;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.TransactionHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirectoryConnector {
    private static final String FILE_PREFIX = "file://";
    private static final String IMPORT_SELECTOR_REGEX = ".*\\.(cer|cert|crt|pem|der)";
    private static final long MAX_IMPORTS_MILLISECONDS = 300000L;
    Logger LOGGER = LoggerFactory.getLogger(DirectoryConnector.class);
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private ImportedURLRepository importedURLRepository;
    @Autowired
    private TransactionHandler transactionHandler;
    @Autowired
    private AuditService auditService;

    public CAStatus getStatus(CAConnectorConfig caConfig) {
        if (caConfig.getCaUrl() == null) {
            this.LOGGER.warn("in retrieveCertificates: url missing");
            return CAStatus.Deactivated;
        }
        String url = caConfig.getCaUrl().toLowerCase();
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try {
                int status = this.getHTTPResponseStatusCode(url);
                if (status >= 200 && status < 400) {
                    return CAStatus.Active;
                }
                this.LOGGER.info("getStatus for url '{}' returns status  {}", (Object)url, (Object)status);
            }
            catch (Exception e) {
                this.LOGGER.warn("in getStatus for url '{}' failed with message {}", (Object)url, (Object)e.getMessage());
            }
        } else {
            File dir = new File(this.getFilename(caConfig));
            if (dir.exists() && dir.canRead()) {
                return CAStatus.Active;
            }
            this.LOGGER.warn("in getStatus: filename '{}', exists {}, can read {}", new Object[]{this.getFilename(caConfig), dir.exists(), dir.canRead()});
        }
        return CAStatus.Problem;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int retrieveCertificates(CAConnectorConfig caConfig) throws IOException {
        String regEx;
        ImportInfo importInfo = new ImportInfo();
        String string = regEx = caConfig.getSelector() != null && caConfig.getSelector().trim().length() > 0 ? caConfig.getSelector().trim() : IMPORT_SELECTOR_REGEX;
        if (caConfig.getCaUrl() == null) {
            this.LOGGER.warn("in retrieveCertificates: url missing");
            return 0;
        }
        String url = caConfig.getCaUrl().toLowerCase();
        if (url.startsWith("http://") || url.startsWith("https://")) {
            Crawler crawler = new Crawler();
            List<String> crawlDomains = Arrays.asList(caConfig.getCaUrl());
            for (String domain : crawlDomains) {
                Set certificateSet = crawler.search(domain, regEx);
                for (String certUrl : certificateSet) {
                    this.importCertifiateFromURL(certUrl, importInfo, caConfig);
                }
            }
        } else {
            File dir = new File(this.getFilename(caConfig));
            this.LOGGER.debug("in retrieveCertificates for directory '{}' using regex '{}'", (Object)dir, (Object)regEx);
            Set certSet = this.listFilesUsingFileWalkAndVisitor(dir.getAbsolutePath(), regEx);
            long startTime = System.currentTimeMillis();
            for (String filename : certSet) {
                this.transactionHandler.runInNewTransaction(() -> this.importCertifiateFromFile(filename, importInfo, caConfig));
                if (System.currentTimeMillis() - startTime <= 300000L) continue;
                this.LOGGER.debug("retrieveCertificates: imported for more than {} sec., delaying ...", (Object)300L);
                break;
            }
        }
        return importInfo.getImported();
    }

    public ImportInfo importCertifiateFromFile(String filename, ImportInfo importInfo, CAConnectorConfig caConfig) {
        try {
            File certFile = new File(filename);
            Instant lastChangeDate = Instant.ofEpochMilli(certFile.lastModified() / 1000L * 1000L);
            List impUrlList = this.importedURLRepository.findEntityByUrl(certFile.toURI().toString());
            if (impUrlList.isEmpty()) {
                try {
                    this.LOGGER.debug("new certificate '{}' found, importing ...", (Object)filename);
                    byte[] content = Files.readAllBytes(Paths.get(filename, new String[0]));
                    Certificate certificate = this.certUtil.createCertificate(content, null, null, false, filename);
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateImported(filename, certificate, caConfig));
                    if (caConfig.getTrustSelfsignedCertificates().booleanValue()) {
                        if (certificate.isSelfsigned()) {
                            if (certificate.isActive()) {
                                certificate.setTrusted(Boolean.valueOf(true));
                                this.certificateRepository.save((Object)certificate);
                                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateTrusted(filename, certificate, caConfig));
                            } else {
                                this.LOGGER.info("selfsigned certificate from file'{}', not active, not set as 'trusted'", (Object)filename);
                            }
                        } else {
                            this.LOGGER.info("'not selfsigned' certificate from file'{}', not active, not set as 'trusted'", (Object)filename);
                        }
                    }
                }
                catch (IOException | GeneralSecurityException e) {
                    this.LOGGER.info("reading and importing certificate from '{}' causes {}", (Object)filename, (Object)e.getLocalizedMessage());
                }
                ImportedURL impUrl = new ImportedURL();
                impUrl.setName(certFile.toURI().toString());
                impUrl.setImportDate(lastChangeDate);
                this.importedURLRepository.save((Object)impUrl);
                this.LOGGER.debug("certificate imported from '{}'", (Object)filename);
                importInfo.incImported();
                return importInfo;
            }
            ImportedURL impUrl = (ImportedURL)impUrlList.get(0);
            if (impUrl.getImportDate().getEpochSecond() != lastChangeDate.getEpochSecond()) {
                this.LOGGER.debug("ImportedURL for '{}' has a different import date {} compared to the files lastChangeDate {}", new Object[]{impUrl.getName(), impUrl.getImportDate().getEpochSecond(), lastChangeDate.getEpochSecond()});
            }
            importInfo.incRejected();
        }
        catch (Throwable th) {
            this.LOGGER.debug("certificate import failed", th);
        }
        return importInfo;
    }

    public ImportInfo importCertifiateFromURL(String url, ImportInfo importInfo, CAConnectorConfig caConfig) {
        try {
            Instant lastChangeDate = Instant.now();
            List impUrlList = this.importedURLRepository.findEntityByUrl(url);
            if (impUrlList.isEmpty()) {
                try {
                    this.LOGGER.debug("new certificate '{}' found, importing ...", (Object)url);
                    DownloadedContent downloadedContent = this.downloadFile(url);
                    lastChangeDate = Instant.ofEpochMilli(downloadedContent.getDate());
                    Certificate certificate = this.certUtil.createCertificate(downloadedContent.getContent(), null, null, false, url);
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateImported(url, certificate, caConfig));
                    this.LOGGER.debug("certificate imported from '{}'", (Object)url);
                }
                catch (IOException | GeneralSecurityException e) {
                    this.LOGGER.info("reading and importing certificate from '{}' causes {}", (Object)url, (Object)e.getLocalizedMessage());
                }
                ImportedURL impUrl = new ImportedURL();
                impUrl.setName(url);
                impUrl.setImportDate(lastChangeDate);
                this.importedURLRepository.save((Object)impUrl);
                importInfo.incImported();
                return importInfo;
            }
            ImportedURL impUrl = (ImportedURL)impUrlList.get(0);
            if (impUrl.getImportDate().getEpochSecond() != lastChangeDate.getEpochSecond()) {
                this.LOGGER.debug("ImportedURL for '{}' has a different import date {} compared to the files lastChangeDate {}", new Object[]{impUrl.getName(), impUrl.getImportDate().getEpochSecond(), lastChangeDate.getEpochSecond()});
            }
            importInfo.incRejected();
        }
        catch (Throwable th) {
            this.LOGGER.debug("certificate import failed", th);
        }
        return importInfo;
    }

    Set<String> listFilesUsingFileWalkAndVisitor(String dir, String regEx) throws IOException {
        HashSet<String> fileList = new HashSet<String>();
        File target = new File(dir);
        if (!target.exists()) {
            this.LOGGER.warn("certificate import from '{}' failed, directory does not exist.", (Object)dir);
            return fileList;
        }
        if (!target.canRead()) {
            this.LOGGER.warn("certificate import from '{}' failed, no read access.", (Object)dir);
            return fileList;
        }
        Pattern pattern = Pattern.compile(regEx);
        Files.walkFileTree(Paths.get(dir, new String[0]), (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        return fileList;
    }

    private String getFilename(CAConnectorConfig caConfig) {
        String url;
        String filename = url = caConfig.getCaUrl();
        if (url.toLowerCase().trim().startsWith(FILE_PREFIX)) {
            filename = url.substring(FILE_PREFIX.length());
        }
        return filename;
    }

    private int getHTTPResponseStatusCode(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        return http.getResponseCode();
    }

    private DownloadedContent downloadFile(String urlString) throws IOException {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.connect();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)baos);
        return new DownloadedContent(baos.toByteArray(), conn.getDate());
    }
}

