/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.saml;

import de.trustable.ca3s.core.config.saml.SAMLMappingConfig;
import de.trustable.ca3s.core.config.util.SPeLUtil;
import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.UserPreference;
import de.trustable.ca3s.core.repository.AuthorityRepository;
import de.trustable.ca3s.core.repository.TenantRepository;
import de.trustable.ca3s.core.repository.UserPreferenceRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.dto.Languages;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.providers.ExpiringUsernameAuthenticationToken;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.transaction.annotation.Transactional;
import org.thymeleaf.util.StringUtils;

public class CustomSAMLAuthenticationProvider
extends SAMLAuthenticationProvider {
    private final Logger LOG = LoggerFactory.getLogger(CustomSAMLAuthenticationProvider.class);
    private final UserPreferenceRepository userPreferenceRepository;
    private final UserRepository userRepository;
    private final AuthorityRepository authorityRepository;
    private final TenantRepository tenantRepository;
    private final SPeLUtil sPeLUtil;
    private final Languages languages;
    private final SAMLMappingConfig samlMappingConfig;

    public CustomSAMLAuthenticationProvider(UserPreferenceRepository userPreferenceRepository, UserRepository userRepository, AuthorityRepository authorityRepository, TenantRepository tenantRepository, SPeLUtil sPeLUtil, String availableLanguages, SAMLMappingConfig samlMappingConfig) {
        this.userPreferenceRepository = userPreferenceRepository;
        this.userRepository = userRepository;
        this.authorityRepository = authorityRepository;
        this.tenantRepository = tenantRepository;
        this.sPeLUtil = sPeLUtil;
        this.languages = new Languages(availableLanguages);
        this.samlMappingConfig = samlMappingConfig;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication authenticationAuthed = super.authenticate(authentication);
        this.LOG.debug("authenticate(authentication) succeeded");
        return authenticationAuthed;
    }

    @Transactional
    public Collection<? extends GrantedAuthority> getEntitlements(SAMLCredential credential, Object userDetail) {
        this.LOG.debug("SAML credential processing");
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if (credential != null && credential.getNameID() != null) {
            this.LOG.debug("saml role '{}' added to granted roles", (Object)credential.getNameID().getValue());
            authorities.add(new SimpleGrantedAuthority(credential.getNameID().getValue()));
            this.storeUserInfo(credential);
        }
        if (userDetail instanceof ExpiringUsernameAuthenticationToken) {
            authorities.addAll(((ExpiringUsernameAuthenticationToken)userDetail).getAuthorities());
            for (GrantedAuthority grantedAuthority : authorities) {
                this.LOG.debug("SAML authority: {}", (Object)grantedAuthority);
            }
        }
        return authorities;
    }

    private void storeUserInfo(SAMLCredential credential) {
        if (credential == null || credential.getNameID() == null) {
            this.LOG.debug("No / not sufficient SAML credentials provided!");
        } else {
            String id = credential.getNameID().getValue();
            Optional userOptional = this.userRepository.findOneByLogin(id);
            if (userOptional.isEmpty()) {
                User user = new User();
                user.setPassword("$0$0$0000000000000000000000000000000000000000000000000000000");
                user.setActivated(true);
                user.setManagedExternally(true);
                user.setLangKey(this.languages.alignLanguage("en"));
                this.updateUserFromSAMLCredentials(id, credential, user);
                UserPreference userPreference = new UserPreference();
                userPreference.setUserId(user.getId());
                userPreference.setName("SAML_ID");
                userPreference.setContent(id);
                this.userPreferenceRepository.save((Object)userPreference);
                this.LOG.info("created new user {}", (Object)user.getId());
            } else {
                User user = (User)userOptional.get();
                this.updateUserFromSAMLCredentials(id, credential, user);
                this.LOG.info("updated known user {}", (Object)user.getId());
            }
        }
    }

    private void updateUserFromSAMLCredentials(String effLoginName, SAMLCredential credential, User user) {
        boolean update = false;
        String firstNameOld = user.getFirstName();
        String lastNameOld = user.getLastName();
        String emailOld = user.getEmail();
        Tenant tenantOld = user.getTenant();
        if (!StringUtils.equals((Object)user.getLogin(), (Object)effLoginName).booleanValue()) {
            this.LOG.info("oidc data updates user name from '{}' to '{}'", (Object)user.getLogin(), (Object)effLoginName);
            user.setLogin(effLoginName);
            update = true;
        }
        for (Attribute saml2Att : credential.getAttributes()) {
            this.LOG.info("SAML attribute '{}' to '{}'", (Object)saml2Att.getName(), (Object)saml2Att.getAttributeValues());
        }
        List<String> attributesFirstNameList = Arrays.asList(this.samlMappingConfig.getAttributesFirstName());
        List<String> attributesLastNameList = Arrays.asList(this.samlMappingConfig.getAttributesLastName());
        List<String> attributesEmailList = Arrays.asList(this.samlMappingConfig.getAttributesEmail());
        List<String> attributesTenantList = Arrays.asList(this.samlMappingConfig.getAttributesTenant());
        HashMap<String, List> attributeMap = new HashMap<String, List>();
        for (Attribute attribute : credential.getAttributes()) {
            attributeMap.put(attribute.getName(), this.fromXMLObjectList(attribute.getAttributeValues()));
            if (attributesFirstNameList.contains(attribute.getName()) && !attribute.getAttributeValues().isEmpty()) {
                user.setFirstName(this.fromXMLObject((XMLObject)attribute.getAttributeValues().get(0)));
            }
            if (attributesLastNameList.contains(attribute.getName()) && !attribute.getAttributeValues().isEmpty()) {
                user.setLastName(this.fromXMLObject((XMLObject)attribute.getAttributeValues().get(0)));
            }
            if (attributesEmailList.contains(attribute.getName()) && !attribute.getAttributeValues().isEmpty()) {
                user.setEmail(this.fromXMLObject((XMLObject)attribute.getAttributeValues().get(0)));
            }
            if (!attributesTenantList.contains(attribute.getName()) || attribute.getAttributeValues().isEmpty()) continue;
            String tenantName = this.fromXMLObject((XMLObject)attribute.getAttributeValues().get(0));
            user.setTenant(this.findTenantByName(tenantName));
        }
        if (this.samlMappingConfig.getExprFirstName() != null && !this.samlMappingConfig.getExprFirstName().isEmpty()) {
            user.setFirstName(this.sPeLUtil.evaluateExpression(attributeMap, this.samlMappingConfig.getExprFirstName()));
        }
        if (this.samlMappingConfig.getExprLastName() != null && !this.samlMappingConfig.getExprLastName().isEmpty()) {
            user.setLastName(this.sPeLUtil.evaluateExpression(attributeMap, this.samlMappingConfig.getExprLastName()));
        }
        if (this.samlMappingConfig.getExprEmail() != null && !this.samlMappingConfig.getExprEmail().isEmpty()) {
            user.setEmail(this.sPeLUtil.evaluateExpression(attributeMap, this.samlMappingConfig.getExprEmail()));
        }
        if (this.samlMappingConfig.getExprTenant() != null && !this.samlMappingConfig.getExprTenant().isEmpty()) {
            String tenantName = this.sPeLUtil.evaluateExpression(attributeMap, this.samlMappingConfig.getExprTenant());
            user.setTenant(this.findTenantByName(tenantName));
        }
        if (firstNameOld != user.getFirstName()) {
            this.LOG.info("oidc first name '{}' updated to '{}'", (Object)firstNameOld, (Object)user.getFirstName());
            update = true;
        }
        if (lastNameOld != user.getLastName()) {
            this.LOG.info("oidc last name '{}' updated to '{}'", (Object)lastNameOld, (Object)user.getLastName());
            update = true;
        }
        if (emailOld != user.getEmail()) {
            this.LOG.info("oidc email '{}' updated to '{}'", (Object)emailOld, (Object)user.getEmail());
            update = true;
        }
        if (!Objects.equals(tenantOld, user.getTenant())) {
            String tenantNameOld = tenantOld == null ? "null" : tenantOld.getName();
            String tenantNameNew = user.getTenant() == null ? "null" : user.getTenant().getName();
            this.LOG.info("tenant '{}' updated to '{}'", (Object)tenantNameOld, (Object)tenantNameNew);
            update = true;
        }
        if (!user.isManagedExternally()) {
            user.setManagedExternally(true);
            update = true;
        }
        HashSet<Authority> authoritySet = new HashSet<Authority>();
        for (Authority authority : this.authorityRepository.findAll()) {
            if (!authority.getName().equalsIgnoreCase("ROLE_USER")) continue;
            authoritySet.add(authority);
        }
        if (authoritySet.containsAll(user.getAuthorities()) && user.getAuthorities().containsAll(authoritySet)) {
            this.LOG.debug("Roles local / oidc are identical");
        } else {
            this.LOG.info("oidc roles '{}' != current roles '{}'", authoritySet, (Object)user.getAuthorities());
            user.setAuthorities(authoritySet);
            update = true;
        }
        if (update) {
            user.setLastUserDetailsUpdate(Instant.now());
        }
        this.userRepository.save((Object)user);
    }

    private Tenant findTenantByName(String tenantName) {
        Optional tenantOptional = this.tenantRepository.findByName(tenantName);
        if (tenantOptional.isEmpty()) {
            this.LOG.info("Unknown tenant: " + tenantName);
            return null;
        }
        Tenant tenant = (Tenant)tenantOptional.get();
        if (!tenant.getActive().booleanValue()) {
            this.LOG.info("tenant: " + tenantName + " deactivated");
            return null;
        }
        return tenant;
    }

    private String fromXMLObject(XMLObject xmlObject) {
        if (xmlObject instanceof XSString) {
            return ((XSString)xmlObject).getValue();
        }
        return xmlObject.toString();
    }

    private List<String> fromXMLObjectList(List<XMLObject> xmlObjectList) {
        return xmlObjectList.stream().map(x -> this.fromXMLObject(x)).collect(Collectors.toList());
    }
}

