/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class StartupApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    Logger LOG = LoggerFactory.getLogger(StartupApplicationListener.class);
    private final BPMNUtil bpmnUtil;
    private final AuditService auditService;

    @Autowired
    public StartupApplicationListener(BPMNUtil bpmnUtil, AuditService auditService) {
        this.bpmnUtil = bpmnUtil;
        this.auditService = auditService;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.auditService.saveAuditTrace(this.auditService.createAuditTraceStarted());
        this.bpmnUtil.updateProcessDefinitions();
    }
}

