/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.repository.AcmeNonceRepository;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.AuditService;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AcmeExpiryScheduler {
    transient Logger LOG = LoggerFactory.getLogger(AcmeExpiryScheduler.class);
    private final int maxRecordsPerTransaction;
    private final AcmeOrderRepository acmeOrderRepository;
    private final AcmeNonceRepository acmeNonceRepository;
    private final AuditService auditService;

    public AcmeExpiryScheduler(@Value(value="${ca3s.batch.maxRecordsPerTransaction:1000}") int maxRecordsPerTransaction, AcmeOrderRepository acmeOrderRepository, AcmeNonceRepository acmeNonceRepository, AuditService auditService) {
        this.acmeOrderRepository = acmeOrderRepository;
        this.acmeNonceRepository = acmeNonceRepository;
        this.auditService = auditService;
        this.maxRecordsPerTransaction = maxRecordsPerTransaction;
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.acmeOrderExpiry:600000}")
    public void runOrderCleanup() {
        Instant now = Instant.now();
        Page acmeOrderExpiredList = this.acmeOrderRepository.findByPendingExpiryBefore((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction), now);
        if (!acmeOrderExpiredList.isEmpty()) {
            this.LOG.info("setting #{} expired orders to status 'invalid'", (Object)acmeOrderExpiredList.getNumberOfElements());
            for (AcmeOrder acmeOrder : acmeOrderExpiredList) {
                acmeOrder.setStatus(AcmeOrderStatus.INVALID);
                this.auditService.createAuditTraceACMEOrderExpired(acmeOrder);
                this.acmeOrderRepository.save((Object)acmeOrder);
            }
        }
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.acmeOrderExpiry:600000}")
    public void runNonceCleanup() {
        Page acmeOrderExpiredList = this.acmeNonceRepository.findByNonceExpiryDate((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction), Instant.now());
        if (!acmeOrderExpiredList.isEmpty()) {
            this.LOG.info("deleting #{} expired nonces", (Object)acmeOrderExpiredList.getNumberOfElements());
            this.acmeNonceRepository.deleteAll((Iterable)acmeOrderExpiredList);
        }
    }
}

