/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Pipeline;
import java.time.Duration;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.jsr107.Eh107Configuration;
import org.springframework.boot.autoconfigure.cache.JCacheManagerCustomizer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.config.JHipsterProperties;

@Configuration
@EnableCaching
public class CacheConfiguration {
    private final javax.cache.configuration.Configuration<Object, Object> jcacheConfiguration;

    public CacheConfiguration(JHipsterProperties jHipsterProperties) {
        JHipsterProperties.Cache.Ehcache ehcache = jHipsterProperties.getCache().getEhcache();
        this.jcacheConfiguration = Eh107Configuration.fromEhcacheCacheConfiguration((org.ehcache.config.CacheConfiguration)CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)ehcache.getMaxEntries())).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(ehcache.getTimeToLiveSeconds()))).build());
    }

    @Bean
    public JCacheManagerCustomizer cacheManagerCustomizer() {
        return cm -> {
            this.createCache(cm, "usersByLogin");
            this.createCache(cm, "usersByEmail");
            this.createCache(cm, CAConnectorConfig.class.getName());
            this.createCache(cm, "AcceptedIssuer");
            this.createCache(cm, "CRLs");
            this.createCache(cm, CSR.class.getName());
            this.createCache(cm, CSR.class.getName() + ".rdns");
            this.createCache(cm, CSR.class.getName() + ".ras");
            this.createCache(cm, CSR.class.getName() + ".csrAttributes");
            this.createCache(cm, Pipeline.class.getName());
            this.createCache(cm, Pipeline.class.getName() + ".pipelineAttributes");
        };
    }

    private void createCache(CacheManager cm, String cacheName) {
        Cache cache = cm.getCache(cacheName);
        if (cache != null) {
            cm.destroyCache(cacheName);
        }
        cm.createCache(cacheName, this.jcacheConfiguration);
    }
}

