/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core;

import de.trustable.ca3s.core.EndpointConfig;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EndpointConfigs {
    private static final Logger log = LoggerFactory.getLogger(EndpointConfigs.class);
    HashMap<Integer, EndpointConfig> portConfigMap = new HashMap();

    EndpointConfigs() {
    }

    public void addConfig(int port, boolean isHttps, String bindingHost, String usageDescription) {
        this.addConfig(port, isHttps, false, bindingHost, usageDescription);
    }

    public void addConfig(int port, boolean isHttps, boolean isClientAuth, String bindingHost, String usageDescription) {
        if (this.portConfigMap.containsKey(port)) {
            EndpointConfig existingConfig = (EndpointConfig)this.portConfigMap.get(port);
            if (existingConfig.isHttps() != isHttps) {
                log.warn("Https redefinition for port {}, ignoring definition for '{}'", (Object)port, (Object)usageDescription);
            }
            if (!existingConfig.getBindingHost().equalsIgnoreCase(bindingHost)) {
                log.warn("Binding Host redefinition for port {}, ignoring definition for '{}'", (Object)port, (Object)usageDescription);
            }
            existingConfig.usageDescription = existingConfig.usageDescription + ", " + usageDescription;
        } else {
            this.portConfigMap.put(port, new EndpointConfig(port, isHttps, isClientAuth, bindingHost, usageDescription));
        }
    }

    public HashMap<Integer, EndpointConfig> getPortConfigMap() {
        return this.portConfigMap;
    }
}

