/*
 * EJBCA REST Interface
 * API reference documentation.
 *
 * OpenAPI spec version: 1.0
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package de.trustable.ca3s.core.service.dto.ejbca;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
/**
 * CertificateRestResponseV2
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2024-02-27T11:17:53.164838525Z[GMT]")

public class CertificateRestResponseV2 {
  @SerializedName("fingerprint")
  private String fingerprint = null;

  @SerializedName("c_afingerprint")
  private String cAfingerprint = null;

  @SerializedName("certificate_profile_id")
  private Integer certificateProfileId = null;

  @SerializedName("end_entity_profile_id")
  private Integer endEntityProfileId = null;

  @SerializedName("expire_date")
  private Long expireDate = null;

  @SerializedName("issuer_dn")
  private String issuerDn = null;

  @SerializedName("not_before")
  private Long notBefore = null;

  @SerializedName("revocation_date")
  private Long revocationDate = null;

  /**
   * Revocation reason
   */
  @JsonAdapter(RevocationReasonEnum.Adapter.class)
  public enum RevocationReasonEnum {
    @SerializedName("-1")
    NUMBER_MINUS_1(-1),
    @SerializedName("0")
    NUMBER_0(0),
    @SerializedName("1")
    NUMBER_1(1),
    @SerializedName("2")
    NUMBER_2(2),
    @SerializedName("3")
    NUMBER_3(3),
    @SerializedName("4")
    NUMBER_4(4),
    @SerializedName("5")
    NUMBER_5(5),
    @SerializedName("6")
    NUMBER_6(6),
    @SerializedName("8")
    NUMBER_8(8),
    @SerializedName("9")
    NUMBER_9(9),
    @SerializedName("10")
    NUMBER_10(10);

    private Integer value;

    RevocationReasonEnum(Integer value) {
      this.value = value;
    }
    public Integer getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static RevocationReasonEnum fromValue(Integer input) {
      for (RevocationReasonEnum b : RevocationReasonEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<RevocationReasonEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RevocationReasonEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public RevocationReasonEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextInt();
        return RevocationReasonEnum.fromValue((Integer)(value));
      }
    }
  }  @SerializedName("revocation_reason")
  private RevocationReasonEnum revocationReason = null;

  @SerializedName("serial_number")
  private String serialNumber = null;

  @SerializedName("status")
  private Integer status = null;

  @SerializedName("subject_alt_name")
  private String subjectAltName = null;

  @SerializedName("subject_dn")
  private String subjectDn = null;

  @SerializedName("subject_key_id")
  private String subjectKeyId = null;

  @SerializedName("tag")
  private String tag = null;

  @SerializedName("type")
  private Integer type = null;

  @SerializedName("udpate_time")
  private Long udpateTime = null;

  @SerializedName("username")
  private String username = null;

  @SerializedName("base64_cert")
  private List<byte[]> base64Cert = null;

  @SerializedName("certificate_request")
  private String certificateRequest = null;

  @SerializedName("crl_partition_index")
  private Integer crlPartitionIndex = null;

  @SerializedName("invalidity_date")
  private Long invalidityDate = null;

  @SerializedName("certificate_profile")
  private String certificateProfile = null;

  @SerializedName("end_entity_profile")
  private String endEntityProfile = null;

   /**
   * Certificate fingerprint
   * @return fingerprint
  **/
  @Schema(example = "123abc456def789ghi123klm456nop789qrs123t", description = "Certificate fingerprint")
  public String getFingerprint() {
    return fingerprint;
  }

   /**
   * Certificate Authority fingerprint
   * @return cAfingerprint
  **/
  @Schema(example = "abc123def456ghi789klm123nop456qrs789tvx1", description = "Certificate Authority fingerprint")
  public String getCAfingerprint() {
    return cAfingerprint;
  }

   /**
   * Certificate Profile Identifier
   * @return certificateProfileId
  **/
  @Schema(example = "1", description = "Certificate Profile Identifier")
  public Integer getCertificateProfileId() {
    return certificateProfileId;
  }

   /**
   * End Entity Profile Identifier
   * @return endEntityProfileId
  **/
  @Schema(example = "1", description = "End Entity Profile Identifier")
  public Integer getEndEntityProfileId() {
    return endEntityProfileId;
  }

   /**
   * Date after which certificate should be considered expired
   * @return expireDate
  **/
  @Schema(example = "2147483647000", description = "Date after which certificate should be considered expired")
  public Long getExpireDate() {
    return expireDate;
  }

   /**
   * Issuer Distinguished Name
   * @return issuerDn
  **/
  @Schema(example = "CN=ExampleCA", description = "Issuer Distinguished Name")
  public String getIssuerDn() {
    return issuerDn;
  }

   /**
   * Date at which certificate became valid
   * @return notBefore
  **/
  @Schema(example = "1659952800011", description = "Date at which certificate became valid")
  public Long getNotBefore() {
    return notBefore;
  }

   /**
   * Revocation date
   * @return revocationDate
  **/
  @Schema(example = "-1", description = "Revocation date")
  public Long getRevocationDate() {
    return revocationDate;
  }

   /**
   * Revocation reason
   * @return revocationReason
  **/
  @Schema(example = "-1", description = "Revocation reason")
  public RevocationReasonEnum getRevocationReason() {
    return revocationReason;
  }

   /**
   * Hex Serial Number
   * @return serialNumber
  **/
  @Schema(example = "1234567890ABCDEF", description = "Hex Serial Number")
  public String getSerialNumber() {
    return serialNumber;
  }

   /**
   * Certificate status
   * @return status
  **/
  @Schema(example = "20", description = "Certificate status")
  public Integer getStatus() {
    return status;
  }

   /**
   * Subject Alternative Name (SAN)
   * @return subjectAltName
  **/
  @Schema(example = "rfc822Name=john.doe@example.com", description = "Subject Alternative Name (SAN)")
  public String getSubjectAltName() {
    return subjectAltName;
  }

   /**
   * Subject Distinguished Name
   * @return subjectDn
  **/
  @Schema(example = "CN=John Doe,SURNAME=Doe,GIVENNAME=John,C=SE", description = "Subject Distinguished Name")
  public String getSubjectDn() {
    return subjectDn;
  }

   /**
   * Subject Key Identifier
   * @return subjectKeyId
  **/
  @Schema(example = "z123abc456def789ghi123klm456nop789qrs123", description = "Subject Key Identifier")
  public String getSubjectKeyId() {
    return subjectKeyId;
  }

   /**
   * Get tag
   * @return tag
  **/
  @Schema(description = "")
  public String getTag() {
    return tag;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public Integer getType() {
    return type;
  }

   /**
   * Update time
   * @return udpateTime
  **/
  @Schema(example = "1659967133000", description = "Update time")
  public Long getUdpateTime() {
    return udpateTime;
  }

   /**
   * Username
   * @return username
  **/
  @Schema(example = "JohnDoe", description = "Username")
  public String getUsername() {
    return username;
  }

   /**
   * Base64 encoded certificate
   * @return base64Cert
  **/
  @Schema(example = "TUlJR...t2A==", description = "Base64 encoded certificate")
  public List<byte[]> getBase64Cert() {
    return base64Cert;
  }

   /**
   * Certificate request
   * @return certificateRequest
  **/
  @Schema(example = "-----BEGIN CERTIFICATE REQUEST----- MIICh...V8shQ== -----END CERTIFICATE REQUEST-----", description = "Certificate request")
  public String getCertificateRequest() {
    return certificateRequest;
  }

   /**
   * CRL partition index
   * @return crlPartitionIndex
  **/
  @Schema(example = "1", description = "CRL partition index")
  public Integer getCrlPartitionIndex() {
    return crlPartitionIndex;
  }

  public CertificateRestResponseV2 invalidityDate(Long invalidityDate) {
    this.invalidityDate = invalidityDate;
    return this;
  }

   /**
   * Invalidity date
   * @return invalidityDate
  **/
  @Schema(example = "-1", description = "Invalidity date")
  public Long getInvalidityDate() {
    return invalidityDate;
  }

  public void setInvalidityDate(Long invalidityDate) {
    this.invalidityDate = invalidityDate;
  }

   /**
   * Certificate Profile Name
   * @return certificateProfile
  **/
  @Schema(example = "ENDUSER", description = "Certificate Profile Name")
  public String getCertificateProfile() {
    return certificateProfile;
  }

   /**
   * End Entity Profile Name
   * @return endEntityProfile
  **/
  @Schema(example = "EMPTY", description = "End Entity Profile Name")
  public String getEndEntityProfile() {
    return endEntityProfile;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CertificateRestResponseV2 certificateRestResponseV2 = (CertificateRestResponseV2) o;
    return Objects.equals(this.fingerprint, certificateRestResponseV2.fingerprint) &&
        Objects.equals(this.cAfingerprint, certificateRestResponseV2.cAfingerprint) &&
        Objects.equals(this.certificateProfileId, certificateRestResponseV2.certificateProfileId) &&
        Objects.equals(this.endEntityProfileId, certificateRestResponseV2.endEntityProfileId) &&
        Objects.equals(this.expireDate, certificateRestResponseV2.expireDate) &&
        Objects.equals(this.issuerDn, certificateRestResponseV2.issuerDn) &&
        Objects.equals(this.notBefore, certificateRestResponseV2.notBefore) &&
        Objects.equals(this.revocationDate, certificateRestResponseV2.revocationDate) &&
        Objects.equals(this.revocationReason, certificateRestResponseV2.revocationReason) &&
        Objects.equals(this.serialNumber, certificateRestResponseV2.serialNumber) &&
        Objects.equals(this.status, certificateRestResponseV2.status) &&
        Objects.equals(this.subjectAltName, certificateRestResponseV2.subjectAltName) &&
        Objects.equals(this.subjectDn, certificateRestResponseV2.subjectDn) &&
        Objects.equals(this.subjectKeyId, certificateRestResponseV2.subjectKeyId) &&
        Objects.equals(this.tag, certificateRestResponseV2.tag) &&
        Objects.equals(this.type, certificateRestResponseV2.type) &&
        Objects.equals(this.udpateTime, certificateRestResponseV2.udpateTime) &&
        Objects.equals(this.username, certificateRestResponseV2.username) &&
        Objects.equals(this.base64Cert, certificateRestResponseV2.base64Cert) &&
        Objects.equals(this.certificateRequest, certificateRestResponseV2.certificateRequest) &&
        Objects.equals(this.crlPartitionIndex, certificateRestResponseV2.crlPartitionIndex) &&
        Objects.equals(this.invalidityDate, certificateRestResponseV2.invalidityDate) &&
        Objects.equals(this.certificateProfile, certificateRestResponseV2.certificateProfile) &&
        Objects.equals(this.endEntityProfile, certificateRestResponseV2.endEntityProfile);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fingerprint, cAfingerprint, certificateProfileId, endEntityProfileId, expireDate, issuerDn, notBefore, revocationDate, revocationReason, serialNumber, status, subjectAltName, subjectDn, subjectKeyId, tag, type, udpateTime, username, base64Cert, certificateRequest, crlPartitionIndex, invalidityDate, certificateProfile, endEntityProfile);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CertificateRestResponseV2 {\n");

    sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
    sb.append("    cAfingerprint: ").append(toIndentedString(cAfingerprint)).append("\n");
    sb.append("    certificateProfileId: ").append(toIndentedString(certificateProfileId)).append("\n");
    sb.append("    endEntityProfileId: ").append(toIndentedString(endEntityProfileId)).append("\n");
    sb.append("    expireDate: ").append(toIndentedString(expireDate)).append("\n");
    sb.append("    issuerDn: ").append(toIndentedString(issuerDn)).append("\n");
    sb.append("    notBefore: ").append(toIndentedString(notBefore)).append("\n");
    sb.append("    revocationDate: ").append(toIndentedString(revocationDate)).append("\n");
    sb.append("    revocationReason: ").append(toIndentedString(revocationReason)).append("\n");
    sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    subjectAltName: ").append(toIndentedString(subjectAltName)).append("\n");
    sb.append("    subjectDn: ").append(toIndentedString(subjectDn)).append("\n");
    sb.append("    subjectKeyId: ").append(toIndentedString(subjectKeyId)).append("\n");
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    udpateTime: ").append(toIndentedString(udpateTime)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    base64Cert: ").append(toIndentedString(base64Cert)).append("\n");
    sb.append("    certificateRequest: ").append(toIndentedString(certificateRequest)).append("\n");
    sb.append("    crlPartitionIndex: ").append(toIndentedString(crlPartitionIndex)).append("\n");
    sb.append("    invalidityDate: ").append(toIndentedString(invalidityDate)).append("\n");
    sb.append("    certificateProfile: ").append(toIndentedString(certificateProfile)).append("\n");
    sb.append("    endEntityProfile: ").append(toIndentedString(endEntityProfile)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
