/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.websocket;

import de.trustable.ca3s.core.web.websocket.dto.AcmeRequestContainer;
import de.trustable.ca3s.core.web.websocket.dto.AcmeResponseContainer;
import de.trustable.ca3s.core.web.websocket.dto.ConnectInfo;
import java.lang.reflect.Type;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;

public class RequestProxyStompSessionHandler
extends StompSessionHandlerAdapter {
    private static final String TOPIC_CONNECTED = "/topic/connected";
    private static final String TOPIC_ACME_PROXIED = "/topic/acmeProxied";
    private Logger logger = LogManager.getLogger(RequestProxyStompSessionHandler.class);

    public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
        this.logger.info("New session established : " + session.getSessionId());
        session.subscribe(TOPIC_ACME_PROXIED, (StompFrameHandler)this);
        this.logger.info("Subscribed to /topic/acmeProxied");
        session.subscribe(TOPIC_CONNECTED, (StompFrameHandler)this);
        this.logger.info("Subscribed to /topic/connected");
        session.send("/requestProxy/connect", (Object)"hello");
        this.logger.info("Connect message sent to request proxy");
    }

    public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
        this.logger.error("Got an exception", exception);
    }

    public Type getPayloadType(StompHeaders headers) {
        if (TOPIC_ACME_PROXIED.equals(headers.getDestination())) {
            return AcmeResponseContainer.class;
        }
        if (TOPIC_CONNECTED.equals(headers.getDestination())) {
            return ConnectInfo.class;
        }
        return String.class;
    }

    public void handleFrame(StompHeaders headers, Object payload) {
        this.logger.info("Received message for {} ", (Object)headers.getDestination());
        if (payload instanceof AcmeResponseContainer) {
            AcmeResponseContainer msg = (AcmeResponseContainer)payload;
            this.logger.info("Received : " + msg.getStatus() + " for : " + msg.getContent());
        } else if (payload instanceof ConnectInfo) {
            ConnectInfo msg = (ConnectInfo)payload;
            this.logger.info("Received connected response for : " + msg.getIp());
        } else {
            this.logger.info("Received payload class {}", (Object)payload.getClass().getName());
            this.logger.info("Received payload {}", (Object)payload.toString());
        }
    }

    private AcmeRequestContainer getSampleMessage() {
        AcmeRequestContainer msg = new AcmeRequestContainer("path", "realm");
        return msg;
    }
}

