/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import com.vdurmont.semver4j.Semver;
import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.repository.BPMNProcessInfoRepository;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.BPMNUpload;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.web.rest.data.BpmnCheckResult;
import de.trustable.ca3s.core.web.rest.support.NotFoundException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.variable.VariableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api"})
public class BPMNUpDownloadController {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNUpDownloadController.class);
    private static final String ENTITY_NAME = "bPMNProcessInfo";
    final BPMNUtil bpmnUtil;
    final BPMNProcessInfoRepository bpmnProcessInfoRepository;
    final CSRRepository csrRepository;
    final CertificateRepository certificateRepository;
    final CAConnectorConfigRepository caConnectorConfigRepository;
    final AuditService auditService;

    public BPMNUpDownloadController(BPMNUtil bpmnUtil, BPMNProcessInfoRepository bpmnProcessInfoRepository, CSRRepository csrRepository, CertificateRepository certificateRepository, CAConnectorConfigRepository caConnectorConfigRepository, AuditService auditService) {
        this.bpmnUtil = bpmnUtil;
        this.bpmnProcessInfoRepository = bpmnProcessInfoRepository;
        this.csrRepository = csrRepository;
        this.certificateRepository = certificateRepository;
        this.caConnectorConfigRepository = caConnectorConfigRepository;
        this.auditService = auditService;
    }

    @RequestMapping(value={"/bpmn/{processId}"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<InputStreamResource> getBPMN(@PathVariable String processId) throws NotFoundException {
        LOG.info("Received bpmn download request for id {} ", (Object)processId);
        for (ProcessDefinition pd : this.bpmnUtil.getProcessDefinitions()) {
            LOG.info("process definition present : id {}, name {} ", (Object)pd.getId(), (Object)pd.getName());
        }
        InputStreamResource inputStreamResource = new InputStreamResource(this.bpmnUtil.getProcessContent(processId));
        return new ResponseEntity((Object)inputStreamResource, HttpStatus.OK);
    }

    @PostMapping(value={"/bpmn"})
    @Transactional
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<BPMNProcessInfo> postBPMN(@Valid @RequestBody BPMNUpload bpmnUpload) {
        LOG.info("Received bpmn upload request with name {} ", (Object)bpmnUpload.getName());
        if (bpmnUpload.getContentXML().trim().isEmpty()) {
            LOG.warn("Received bpmn upload request with name {} has no XML content!", (Object)bpmnUpload.getName());
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        String processDefinitionId = this.bpmnUtil.addModel(bpmnUpload.getContentXML(), bpmnUpload.getName());
        LOG.debug("Deployed bpmn document with processDefinitionId {} successfully", (Object)processDefinitionId);
        BPMNProcessInfo bpmnProcessInfo = this.bpmnUtil.buildBPMNProcessInfoByProcessId(processDefinitionId, bpmnUpload.getName(), bpmnUpload.getType());
        return new ResponseEntity((Object)bpmnProcessInfo, HttpStatus.OK);
    }

    @PutMapping(value={"/bpmn"})
    @Transactional
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<BPMNProcessInfo> putBPMNProcessInfo(@Valid @RequestBody BPMNUpload bpmnUpload) {
        LOG.info("Received bpmn upload request with name {} ", (Object)bpmnUpload.getName());
        LOG.debug("REST request to update BPMNProcessInfo : {}", (Object)bpmnUpload);
        if (bpmnUpload.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        ArrayList<AuditTrace> auditList = new ArrayList<AuditTrace>();
        Optional optionalBpmnProcessInfo = this.bpmnProcessInfoRepository.findById((Object)bpmnUpload.getId());
        if (optionalBpmnProcessInfo.isPresent()) {
            BPMNProcessInfo bpmnProcessInfo = (BPMNProcessInfo)optionalBpmnProcessInfo.get();
            if (!Objects.equals(bpmnUpload.getName(), bpmnProcessInfo.getName())) {
                auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_NAME_CHANGED", bpmnProcessInfo.getName(), bpmnUpload.getName(), bpmnProcessInfo));
                bpmnProcessInfo.setName(bpmnUpload.getName());
            }
            if (!Objects.equals(bpmnUpload.getType(), bpmnProcessInfo.getType())) {
                auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_TYPE_CHANGED", bpmnProcessInfo.getType().name(), bpmnUpload.getName(), bpmnProcessInfo));
                bpmnProcessInfo.setType(bpmnUpload.getType());
            }
            if (bpmnUpload.getContentXML() == null || bpmnUpload.getContentXML().trim().isEmpty()) {
                LOG.debug("Received bpmn upload request with name {} without new XML content!", (Object)bpmnUpload.getName());
            } else {
                Semver newVersion;
                Semver currentVersion = new Semver(bpmnProcessInfo.getVersion());
                if (bpmnUpload.getVersion() == null || bpmnUpload.getVersion().isEmpty()) {
                    LOG.info("unexpected format of version field! Ignoring value.");
                    newVersion = currentVersion.nextPatch();
                } else {
                    newVersion = new Semver(bpmnUpload.getVersion());
                    if (newVersion.isGreaterThan(currentVersion)) {
                        newVersion = currentVersion.nextPatch();
                    }
                }
                bpmnProcessInfo.setVersion(newVersion.toString());
                bpmnProcessInfo.setLastChange(Instant.now());
                String oldProcessDefinitionId = bpmnProcessInfo.getProcessId();
                String processDefinitionId = this.bpmnUtil.addModel(bpmnUpload.getContentXML(), bpmnUpload.getName());
                LOG.debug("Deployed bpmn document with processDefinitionId {} successfully", (Object)processDefinitionId);
                auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_PROCESS_ID_CHANGED", oldProcessDefinitionId, processDefinitionId, bpmnProcessInfo));
                bpmnProcessInfo.setProcessId(processDefinitionId);
                this.bpmnUtil.deleteProcessDefinitions(oldProcessDefinitionId);
            }
            this.bpmnProcessInfoRepository.save((Object)bpmnProcessInfo);
            this.auditService.saveAuditTrace(auditList);
            return new ResponseEntity((Object)bpmnProcessInfo, HttpStatus.OK);
        }
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/bpmn/check/csr/{processId}/{csrId}"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<Map<String, String>> postBPMNForCSR(@PathVariable String processId, @PathVariable String csrId) {
        LOG.info("Received bpmn check request for process id {} and csr id {}", (Object)processId, (Object)csrId);
        Optional csrOpt = this.csrRepository.findById((Object)Long.parseLong(csrId));
        CAConnectorConfig caConfig = (CAConnectorConfig)this.caConnectorConfigRepository.getOne((Object)1L);
        ProcessInstanceWithVariables processInstanceWithVariables = this.bpmnUtil.checkCertificateCreationProcess((CSR)csrOpt.get(), caConfig, processId);
        if (processInstanceWithVariables != null) {
            BpmnCheckResult result = new BpmnCheckResult();
            VariableMap variables = processInstanceWithVariables.getVariables();
            for (String key : variables.keySet()) {
                if ("csrAttributes".equals(key)) {
                    for (CsrAttribute csrAtt : (Set)variables.get(key)) {
                        LOG.info("bpmn process returns CsrAttribute {} with value {}", (Object)csrAtt.getName(), (Object)csrAtt.getValue());
                        result.getCsrAttributes().add(new ImmutablePair((Object)csrAtt.getName(), (Object)csrAtt.getValue()));
                    }
                    continue;
                }
                if ("failureReason".equals(key)) {
                    result.setFailureReason(variables.get(key).toString());
                    continue;
                }
                if ("status".equals(key)) {
                    result.setStatus(variables.get(key).toString());
                    continue;
                }
                if ("isActive".equals(key)) {
                    result.setActive(Boolean.valueOf(Boolean.parseBoolean(variables.get(key).toString())));
                    continue;
                }
                String value = variables.get(key).toString();
                LOG.info("bpmn process returns variable {} with value {}", (Object)key, (Object)value);
                result.getResponseAttributes().add(new ImmutablePair((Object)key, (Object)value));
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/bpmn/check/certificateNotify/{processId}/{certificateId}"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<Map<String, String>> postBPMNForCertificateNotify(@PathVariable String processId, @PathVariable String certificateId) {
        LOG.info("Received bpmn check certificate notification request for process id {} and certificate id {}", (Object)processId, (Object)certificateId);
        Optional certificateOptional = this.certificateRepository.findById((Object)Long.parseLong(certificateId));
        CAConnectorConfig caConfig = (CAConnectorConfig)this.caConnectorConfigRepository.getOne((Object)1L);
        ProcessInstanceWithVariables processInstanceWithVariables = this.bpmnUtil.checkCertificateNotificationProcess((Certificate)certificateOptional.get(), caConfig, processId);
        if (processInstanceWithVariables != null) {
            BpmnCheckResult result = new BpmnCheckResult();
            VariableMap variables = processInstanceWithVariables.getVariables();
            for (String key : variables.keySet()) {
                if ("failureReason".equals(key)) {
                    result.setFailureReason(variables.get(key).toString());
                    continue;
                }
                if ("status".equals(key)) {
                    result.setStatus(variables.get(key).toString());
                    continue;
                }
                if ("isActive".equals(key)) {
                    result.setActive(Boolean.valueOf(Boolean.parseBoolean(variables.get(key).toString())));
                    continue;
                }
                String value = variables.get(key).toString();
                LOG.info("bpmn process returns variable {} with value {}", (Object)key, (Object)value);
                result.getResponseAttributes().add(new ImmutablePair((Object)key, (Object)value));
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/bpmn/check/accountRequest/{processId}"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<Map<String, String>> postBPMNAccountRequest(@PathVariable String processId) {
        LOG.info("Call bpmn request for process id {}", (Object)processId);
        ProcessInstanceWithVariables processInstanceWithVariables = this.bpmnUtil.checkAccountRequest(processId);
        if (processInstanceWithVariables != null) {
            BpmnCheckResult result = new BpmnCheckResult();
            VariableMap variables = processInstanceWithVariables.getVariables();
            for (String key : variables.keySet()) {
                String value = variables.get(key).toString();
                LOG.info("bpmn process returns variable {} with value {}", (Object)key, (Object)value);
                result.getResponseAttributes().add(new ImmutablePair((Object)key, (Object)value));
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/bpmn/check/batch/{processId}"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    @Transactional
    public ResponseEntity<Map<String, String>> postBPMNBatch(@PathVariable String processId) {
        LOG.info("Call bpmn request for process id {}", (Object)processId);
        ProcessInstanceWithVariables processInstanceWithVariables = this.bpmnUtil.checkBatchProcess(processId);
        if (processInstanceWithVariables != null) {
            BpmnCheckResult result = new BpmnCheckResult();
            VariableMap variables = processInstanceWithVariables.getVariables();
            for (String key : variables.keySet()) {
                String value = variables.get(key).toString();
                LOG.info("bpmn process returns variable {} with value {}", (Object)key, (Object)value);
                result.getResponseAttributes().add(new ImmutablePair((Object)key, (Object)value));
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }
}

