/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.security.jwt.TokenProvider;
import de.trustable.ca3s.core.service.util.UserUtil;
import de.trustable.ca3s.core.web.rest.JWTToken;
import de.trustable.ca3s.core.web.rest.vm.LoginVM;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class UserJWTController {
    private final Logger log = LoggerFactory.getLogger(UserJWTController.class);
    private final TokenProvider tokenProvider;
    private final AuthenticationManagerBuilder authenticationManagerBuilder;
    private final UserUtil userUtil;

    public UserJWTController(TokenProvider tokenProvider, AuthenticationManagerBuilder authenticationManagerBuilder, UserUtil userUtil) {
        this.tokenProvider = tokenProvider;
        this.authenticationManagerBuilder = authenticationManagerBuilder;
        this.userUtil = userUtil;
    }

    @PostMapping(value={"/authenticate"})
    public ResponseEntity<JWTToken> authorize(@Valid @RequestBody LoginVM loginVM) {
        this.userUtil.checkIPBlocked(loginVM.getUsername());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.log.info("--- is already authenticated: {}", (Object)authentication.isAuthenticated());
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)loginVM.getUsername(), (Object)loginVM.getPassword());
        try {
            Authentication authentication2 = ((AuthenticationManager)this.authenticationManagerBuilder.getObject()).authenticate((Authentication)authenticationToken);
            this.userUtil.handleSuccesfulAuthentication(loginVM.getUsername());
            SecurityContextHolder.getContext().setAuthentication(authentication2);
            String jwt = this.tokenProvider.createToken(authentication2, loginVM.isRememberMe());
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Authorization", "Bearer " + jwt);
            return new ResponseEntity((Object)new JWTToken(jwt), (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (BadCredentialsException badCredentialsException) {
            this.log.info("login failed for user '" + loginVM.getUsername() + "'!", (Throwable)badCredentialsException);
            this.userUtil.handleBadCredentials(loginVM.getUsername());
            throw badCredentialsException;
        }
        catch (AuthenticationException authenticationException) {
            this.log.info("login failed for user '" + loginVM.getUsername() + "'!", (Throwable)authenticationException);
            throw authenticationException;
        }
    }
}

