/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.exception.IntegrityException;
import de.trustable.ca3s.core.service.PipelineService;
import de.trustable.ca3s.core.service.dto.AuditView;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@Transactional
@RequestMapping(value={"/api"})
public class PipelineViewResource {
    private final Logger log = LoggerFactory.getLogger(PipelineViewResource.class);
    private static final String ENTITY_NAME = "pipeline";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final PipelineService pipelineService;
    private final PipelineUtil pipelineUtil;

    public PipelineViewResource(PipelineService pipelineService, PipelineUtil pipelineUtil) {
        this.pipelineService = pipelineService;
        this.pipelineUtil = pipelineUtil;
    }

    @PostMapping(value={"/pipelineViews"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<PipelineView> createPipeline(@Valid @RequestBody PipelineView pipelineView) throws URISyntaxException {
        this.log.debug("REST request to save PipelineView : {}", (Object)pipelineView);
        if (pipelineView.getId() != null) {
            throw new BadRequestAlertException("A new pipeline request cannot have an ID", ENTITY_NAME, "idexists");
        }
        if ((PipelineType.ACME.equals((Object)pipelineView.getType()) || PipelineType.SCEP.equals((Object)pipelineView.getType())) && this.pipelineUtil.getPipelineByRealm(pipelineView.getType(), pipelineView.getUrlPart()) != null) {
            throw new BadRequestAlertException("Realm '" + pipelineView.getUrlPart() + "' already exists", ENTITY_NAME, "realmexists");
        }
        Pipeline p = this.pipelineUtil.toPipeline(pipelineView);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/pipelineViews/" + p.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)p.getId().toString()))).body((Object)pipelineView);
    }

    @PutMapping(value={"/pipelineViews"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<PipelineView> updatePipeline(@Valid @RequestBody PipelineView pipelineView) throws URISyntaxException {
        this.log.debug("REST request to update PipelineView : {}", (Object)pipelineView);
        if (pipelineView.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        Pipeline p = this.pipelineUtil.toPipeline(pipelineView);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)p.getId().toString()))).body((Object)pipelineView);
    }

    @GetMapping(value={"/pipelineViews"})
    public List<PipelineView> getAllPipelines() {
        this.log.debug("REST request to get all PipelineViews");
        ArrayList<PipelineView> pvList = new ArrayList<PipelineView>();
        for (Pipeline p : this.pipelineService.findAll()) {
            pvList.add(this.pipelineUtil.from(p));
        }
        return pvList;
    }

    @GetMapping(value={"/pipelineViews/{id}"})
    public ResponseEntity<PipelineView> getPipeline(@PathVariable Long id) {
        this.log.debug("REST request to get PipelineView : {}", (Object)id);
        Optional pipelineOpt = this.pipelineService.findOne(id);
        Optional<Object> pvOpt = Optional.empty();
        if (pipelineOpt.isPresent()) {
            Pipeline p = (Pipeline)pipelineOpt.get();
            PipelineView pv = this.pipelineUtil.from(p);
            ArrayList auditList = new ArrayList();
            pv.setAuditViewArr(auditList.toArray(new AuditView[0]));
            pvOpt = Optional.of(pv);
        }
        return ResponseUtil.wrapOrNotFound(pvOpt);
    }

    @DeleteMapping(value={"/pipelineViews/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deletePipeline(@PathVariable Long id) {
        this.log.debug("REST request to delete Pipeline : {}", (Object)id);
        try {
            this.pipelineService.delete(id);
        }
        catch (RuntimeException dive) {
            this.log.debug("Pipeline deletion failed", (Throwable)dive);
            throw new IntegrityException("Pipeline already used");
        }
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

