/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.security.jwt.TokenProvider;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kerberos"})
public class KerberosAuthenticationResource {
    private final Logger log = LoggerFactory.getLogger(KerberosAuthenticationResource.class);
    private final TokenProvider tokenProvider;
    private final AuthenticationManagerBuilder authenticationManagerBuilder;

    public KerberosAuthenticationResource(TokenProvider tokenProvider, AuthenticationManagerBuilder authenticationManagerBuilder) {
        this.tokenProvider = tokenProvider;
        this.authenticationManagerBuilder = authenticationManagerBuilder;
    }

    @GetMapping(value={"/authenticatedUser"})
    public ResponseEntity<String> getAuthenticatedUser(HttpServletRequest request) {
        if (request.getUserPrincipal() == null) {
            this.log.info("Not authenticated");
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        this.log.info("REST request to check if the current user is authenticated. User {}, Principal {}, authType {}", new Object[]{request.getRemoteUser(), request.getUserPrincipal().getName(), request.getAuthType()});
        SecurityContext securityContext = SecurityContextHolder.getContext();
        this.log.info("Authentication by SecurityContext: " + securityContext.getAuthentication());
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)request.getUserPrincipal().getName(), (Object)"KerberosToken");
        securityContext.setAuthentication((Authentication)authentication);
        String jwt = this.tokenProvider.createToken((Authentication)authentication, false);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization", "Bearer " + jwt);
        this.log.info("Bearer Token created for Kerberos Authentication");
        return new ResponseEntity((Object)request.getRemoteUser(), (MultiValueMap)httpHeaders, HttpStatus.OK);
    }
}

