/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.exception.PasswordRestrictionMismatch;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtil {
    Logger LOG = LoggerFactory.getLogger(PasswordUtil.class);
    private final String passwordCheckRegExp;
    private final Pattern passwordCheckPattern;

    public PasswordUtil(String passwordCheckRegExp) {
        this.passwordCheckRegExp = passwordCheckRegExp;
        this.passwordCheckPattern = Pattern.compile(passwordCheckRegExp);
    }

    public void checkPassword(String password) {
        this.checkPassword(password, "password");
    }

    public void checkPassword(String password, String elementName) {
        if (password == null || !this.passwordCheckPattern.matcher(password).matches()) {
            throw new PasswordRestrictionMismatch(elementName + " does not match restriction '" + this.passwordCheckRegExp + "'");
        }
        this.LOG.debug("password matches restrictions");
    }

    static String maskPassword(String password) {
        String mask = "******";
        String paddedSecret = "******" + password;
        return "******" + paddedSecret.substring(paddedSecret.length() - 4);
    }
}

