/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.ScepOrder;
import de.trustable.ca3s.core.repository.ScepOrderRepository;
import de.trustable.ca3s.core.service.ScepOrderService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ScepOrderServiceImpl
implements ScepOrderService {
    private final Logger log = LoggerFactory.getLogger(ScepOrderServiceImpl.class);
    private final ScepOrderRepository scepOrderRepository;

    public ScepOrderServiceImpl(ScepOrderRepository scepOrderRepository) {
        this.scepOrderRepository = scepOrderRepository;
    }

    public ScepOrder save(ScepOrder scepOrder) {
        this.log.debug("Request to save ScepOrder : {}", (Object)scepOrder);
        return (ScepOrder)this.scepOrderRepository.save((Object)scepOrder);
    }

    @Transactional(readOnly=true)
    public List<ScepOrder> findAll() {
        this.log.debug("Request to get all ScepOrders");
        return this.scepOrderRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<ScepOrder> findOne(Long id) {
        this.log.debug("Request to get ScepOrder : {}", (Object)id);
        return this.scepOrderRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete ScepOrder : {}", (Object)id);
        this.scepOrderRepository.deleteById((Object)id);
    }
}

