/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.ejbca;

import com.google.gson.annotations.SerializedName;
import de.trustable.ca3s.core.service.dto.ejbca.CertificateRestResponseV2;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;

public class CertificateRestResponseV2 {
    @SerializedName(value="fingerprint")
    private String fingerprint = null;
    @SerializedName(value="c_afingerprint")
    private String cAfingerprint = null;
    @SerializedName(value="certificate_profile_id")
    private Integer certificateProfileId = null;
    @SerializedName(value="end_entity_profile_id")
    private Integer endEntityProfileId = null;
    @SerializedName(value="expire_date")
    private Long expireDate = null;
    @SerializedName(value="issuer_dn")
    private String issuerDn = null;
    @SerializedName(value="not_before")
    private Long notBefore = null;
    @SerializedName(value="revocation_date")
    private Long revocationDate = null;
    @SerializedName(value="revocation_reason")
    private RevocationReasonEnum revocationReason = null;
    @SerializedName(value="serial_number")
    private String serialNumber = null;
    @SerializedName(value="status")
    private Integer status = null;
    @SerializedName(value="subject_alt_name")
    private String subjectAltName = null;
    @SerializedName(value="subject_dn")
    private String subjectDn = null;
    @SerializedName(value="subject_key_id")
    private String subjectKeyId = null;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="type")
    private Integer type = null;
    @SerializedName(value="udpate_time")
    private Long udpateTime = null;
    @SerializedName(value="username")
    private String username = null;
    @SerializedName(value="base64_cert")
    private List<byte[]> base64Cert = null;
    @SerializedName(value="certificate_request")
    private String certificateRequest = null;
    @SerializedName(value="crl_partition_index")
    private Integer crlPartitionIndex = null;
    @SerializedName(value="invalidity_date")
    private Long invalidityDate = null;
    @SerializedName(value="certificate_profile")
    private String certificateProfile = null;
    @SerializedName(value="end_entity_profile")
    private String endEntityProfile = null;

    @Schema(example="123abc456def789ghi123klm456nop789qrs123t", description="Certificate fingerprint")
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Schema(example="abc123def456ghi789klm123nop456qrs789tvx1", description="Certificate Authority fingerprint")
    public String getCAfingerprint() {
        return this.cAfingerprint;
    }

    @Schema(example="1", description="Certificate Profile Identifier")
    public Integer getCertificateProfileId() {
        return this.certificateProfileId;
    }

    @Schema(example="1", description="End Entity Profile Identifier")
    public Integer getEndEntityProfileId() {
        return this.endEntityProfileId;
    }

    @Schema(example="2147483647000", description="Date after which certificate should be considered expired")
    public Long getExpireDate() {
        return this.expireDate;
    }

    @Schema(example="CN=ExampleCA", description="Issuer Distinguished Name")
    public String getIssuerDn() {
        return this.issuerDn;
    }

    @Schema(example="1659952800011", description="Date at which certificate became valid")
    public Long getNotBefore() {
        return this.notBefore;
    }

    @Schema(example="-1", description="Revocation date")
    public Long getRevocationDate() {
        return this.revocationDate;
    }

    @Schema(example="-1", description="Revocation reason")
    public RevocationReasonEnum getRevocationReason() {
        return this.revocationReason;
    }

    @Schema(example="1234567890ABCDEF", description="Hex Serial Number")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Schema(example="20", description="Certificate status")
    public Integer getStatus() {
        return this.status;
    }

    @Schema(example="rfc822Name=john.doe@example.com", description="Subject Alternative Name (SAN)")
    public String getSubjectAltName() {
        return this.subjectAltName;
    }

    @Schema(example="CN=John Doe,SURNAME=Doe,GIVENNAME=John,C=SE", description="Subject Distinguished Name")
    public String getSubjectDn() {
        return this.subjectDn;
    }

    @Schema(example="z123abc456def789ghi123klm456nop789qrs123", description="Subject Key Identifier")
    public String getSubjectKeyId() {
        return this.subjectKeyId;
    }

    @Schema(description="")
    public String getTag() {
        return this.tag;
    }

    @Schema(description="")
    public Integer getType() {
        return this.type;
    }

    @Schema(example="1659967133000", description="Update time")
    public Long getUdpateTime() {
        return this.udpateTime;
    }

    @Schema(example="JohnDoe", description="Username")
    public String getUsername() {
        return this.username;
    }

    @Schema(example="TUlJR...t2A==", description="Base64 encoded certificate")
    public List<byte[]> getBase64Cert() {
        return this.base64Cert;
    }

    @Schema(example="-----BEGIN CERTIFICATE REQUEST----- MIICh...V8shQ== -----END CERTIFICATE REQUEST-----", description="Certificate request")
    public String getCertificateRequest() {
        return this.certificateRequest;
    }

    @Schema(example="1", description="CRL partition index")
    public Integer getCrlPartitionIndex() {
        return this.crlPartitionIndex;
    }

    public CertificateRestResponseV2 invalidityDate(Long invalidityDate) {
        this.invalidityDate = invalidityDate;
        return this;
    }

    @Schema(example="-1", description="Invalidity date")
    public Long getInvalidityDate() {
        return this.invalidityDate;
    }

    public void setInvalidityDate(Long invalidityDate) {
        this.invalidityDate = invalidityDate;
    }

    @Schema(example="ENDUSER", description="Certificate Profile Name")
    public String getCertificateProfile() {
        return this.certificateProfile;
    }

    @Schema(example="EMPTY", description="End Entity Profile Name")
    public String getEndEntityProfile() {
        return this.endEntityProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateRestResponseV2 certificateRestResponseV2 = (CertificateRestResponseV2)o;
        return Objects.equals(this.fingerprint, certificateRestResponseV2.fingerprint) && Objects.equals(this.cAfingerprint, certificateRestResponseV2.cAfingerprint) && Objects.equals(this.certificateProfileId, certificateRestResponseV2.certificateProfileId) && Objects.equals(this.endEntityProfileId, certificateRestResponseV2.endEntityProfileId) && Objects.equals(this.expireDate, certificateRestResponseV2.expireDate) && Objects.equals(this.issuerDn, certificateRestResponseV2.issuerDn) && Objects.equals(this.notBefore, certificateRestResponseV2.notBefore) && Objects.equals(this.revocationDate, certificateRestResponseV2.revocationDate) && Objects.equals(this.revocationReason, certificateRestResponseV2.revocationReason) && Objects.equals(this.serialNumber, certificateRestResponseV2.serialNumber) && Objects.equals(this.status, certificateRestResponseV2.status) && Objects.equals(this.subjectAltName, certificateRestResponseV2.subjectAltName) && Objects.equals(this.subjectDn, certificateRestResponseV2.subjectDn) && Objects.equals(this.subjectKeyId, certificateRestResponseV2.subjectKeyId) && Objects.equals(this.tag, certificateRestResponseV2.tag) && Objects.equals(this.type, certificateRestResponseV2.type) && Objects.equals(this.udpateTime, certificateRestResponseV2.udpateTime) && Objects.equals(this.username, certificateRestResponseV2.username) && Objects.equals(this.base64Cert, certificateRestResponseV2.base64Cert) && Objects.equals(this.certificateRequest, certificateRestResponseV2.certificateRequest) && Objects.equals(this.crlPartitionIndex, certificateRestResponseV2.crlPartitionIndex) && Objects.equals(this.invalidityDate, certificateRestResponseV2.invalidityDate) && Objects.equals(this.certificateProfile, certificateRestResponseV2.certificateProfile) && Objects.equals(this.endEntityProfile, certificateRestResponseV2.endEntityProfile);
    }

    public int hashCode() {
        return Objects.hash(this.fingerprint, this.cAfingerprint, this.certificateProfileId, this.endEntityProfileId, this.expireDate, this.issuerDn, this.notBefore, this.revocationDate, this.revocationReason, this.serialNumber, this.status, this.subjectAltName, this.subjectDn, this.subjectKeyId, this.tag, this.type, this.udpateTime, this.username, this.base64Cert, this.certificateRequest, this.crlPartitionIndex, this.invalidityDate, this.certificateProfile, this.endEntityProfile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CertificateRestResponseV2 {\n");
        sb.append("    fingerprint: ").append(this.toIndentedString((Object)this.fingerprint)).append("\n");
        sb.append("    cAfingerprint: ").append(this.toIndentedString((Object)this.cAfingerprint)).append("\n");
        sb.append("    certificateProfileId: ").append(this.toIndentedString((Object)this.certificateProfileId)).append("\n");
        sb.append("    endEntityProfileId: ").append(this.toIndentedString((Object)this.endEntityProfileId)).append("\n");
        sb.append("    expireDate: ").append(this.toIndentedString((Object)this.expireDate)).append("\n");
        sb.append("    issuerDn: ").append(this.toIndentedString((Object)this.issuerDn)).append("\n");
        sb.append("    notBefore: ").append(this.toIndentedString((Object)this.notBefore)).append("\n");
        sb.append("    revocationDate: ").append(this.toIndentedString((Object)this.revocationDate)).append("\n");
        sb.append("    revocationReason: ").append(this.toIndentedString((Object)this.revocationReason)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString((Object)this.serialNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subjectAltName: ").append(this.toIndentedString((Object)this.subjectAltName)).append("\n");
        sb.append("    subjectDn: ").append(this.toIndentedString((Object)this.subjectDn)).append("\n");
        sb.append("    subjectKeyId: ").append(this.toIndentedString((Object)this.subjectKeyId)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString((Object)this.tag)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    udpateTime: ").append(this.toIndentedString((Object)this.udpateTime)).append("\n");
        sb.append("    username: ").append(this.toIndentedString((Object)this.username)).append("\n");
        sb.append("    base64Cert: ").append(this.toIndentedString((Object)this.base64Cert)).append("\n");
        sb.append("    certificateRequest: ").append(this.toIndentedString((Object)this.certificateRequest)).append("\n");
        sb.append("    crlPartitionIndex: ").append(this.toIndentedString((Object)this.crlPartitionIndex)).append("\n");
        sb.append("    invalidityDate: ").append(this.toIndentedString((Object)this.invalidityDate)).append("\n");
        sb.append("    certificateProfile: ").append(this.toIndentedString((Object)this.certificateProfile)).append("\n");
        sb.append("    endEntityProfile: ").append(this.toIndentedString((Object)this.endEntityProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

