/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.badkeys;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.trustable.ca3s.core.service.badkeys.BadKeysResult;
import de.trustable.ca3s.core.service.badkeys.BadKeysResultResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BadKeysService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BadKeysService.class);
    private final boolean useBadkeys;
    private final String badkeysExecutable;
    private final File badkeysDirectory;
    private List<String> availableChecks;
    private boolean isInstalled = false;

    public BadKeysService(@Value(value="${ca3s.badkeys.use:false}") boolean useBadkeys, @Value(value="${ca3s.badkeys.executable:badkeys-cli}") String badkeysExecutable, @Value(value="${ca3s.badkeys.directory:/var/opt/badkeys}") File badkeysDirectory) {
        this.useBadkeys = useBadkeys;
        this.badkeysExecutable = badkeysExecutable;
        this.badkeysDirectory = badkeysDirectory;
        if (useBadkeys && badkeysDirectory.exists() && badkeysDirectory.canRead()) {
            try {
                this.availableChecks = this.invokeBadKeysInfo();
                if (this.availableChecks.size() > 5) {
                    this.isInstalled = true;
                } else {
                    LOGGER.info("Too few ({}) checks available, check your BadKeys installation!", (Object)this.availableChecks.size());
                }
            }
            catch (IOException e) {
                LOGGER.info("BadKeysService cTor", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BadKeysResult checkContent(String pemContent) {
        if (!this.useBadkeys) {
            return new BadKeysResult(false, false, "useBadkeys == false");
        }
        if (!this.badkeysDirectory.exists()) {
            return new BadKeysResult(false, false, "badkeysDirectory '" + this.badkeysDirectory.getAbsolutePath() + "' does not exist");
        }
        if (!this.badkeysDirectory.canRead()) {
            return new BadKeysResult(false, false, "cannot access badkeysDirectory '" + this.badkeysDirectory.getAbsolutePath() + "', check access rights.");
        }
        File inputFile = null;
        try {
            BadKeysResult badKeysResult;
            inputFile = File.createTempFile("badKeysInput_", ".pem");
            FileOutputStream fos = new FileOutputStream(inputFile);
            try {
                fos.write(pemContent.getBytes());
                fos.flush();
                badKeysResult = this.invokeBadKeys(inputFile);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("problem occurred writing file temporarily", (Throwable)e);
                    BadKeysResult badKeysResult2 = new BadKeysResult(false, "problem occurred writing temp file ");
                    return badKeysResult2;
                }
            }
            fos.close();
            return badKeysResult;
        }
        finally {
            if (inputFile != null) {
                LOGGER.debug("deleting temp file '{}'", (Object)inputFile.getAbsolutePath());
                if (!inputFile.delete()) {
                    LOGGER.warn("deleting temp file '{}' failed, please cleanup manually!", (Object)inputFile.getAbsolutePath());
                }
            }
        }
    }

    private BadKeysResult invokeBadKeys(File inputFile) throws IOException {
        String badKeyArg = this.badkeysExecutable + " -j -v " + inputFile.getAbsolutePath();
        Process process = Runtime.getRuntime().exec(badKeyArg, null, this.badkeysDirectory);
        for (int i = 0; i < 20; ++i) {
            try {
                int exitValue = process.exitValue();
                LOGGER.debug("badkeys process returns with code {}", (Object)exitValue);
                BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
                if (exitValue != 0) {
                    String errMsg = output.readLine();
                    LOGGER.warn("badkeys failed with message: {}", (Object)errMsg);
                    return new BadKeysResult(false, errMsg);
                }
                JsonObject jsonObject = JsonParser.parseReader((Reader)output).getAsJsonObject();
                LOGGER.debug("badkeys process returns json:\n{}", (Object)jsonObject.toString());
                BadKeysResultResponse response = new BadKeysResultResponse(jsonObject);
                return new BadKeysResult(response);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        process.destroyForcibly();
        return new BadKeysResult(false, "problem calling / controlling badkeys process ");
    }

    private List<String> invokeBadKeysInfo() throws IOException {
        String badKeyArg = this.badkeysExecutable + " --list";
        Process process = Runtime.getRuntime().exec(badKeyArg, null, this.badkeysDirectory);
        ArrayList<String> checkList = new ArrayList<String>();
        for (int i = 0; i < 20; ++i) {
            try {
                String check;
                int exitValue = process.exitValue();
                LOGGER.info("badkeys info process returns with code {}", (Object)exitValue);
                if (exitValue != 0) {
                    throw new IOException("invocation of badkeys failed with prcess status " + exitValue);
                }
                BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((check = output.readLine()) != null) {
                    LOGGER.debug("badkeys offers check :{}", (Object)check);
                    checkList.add(check);
                }
                return checkList;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        process.destroyForcibly();
        throw new IOException("invocation of badkeys failed");
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public List<String> getAvailableChecks() {
        return this.availableChecks;
    }
}

