/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.adcs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import de.trustable.ca3s.adcsCertUtil.ADCSException;
import de.trustable.ca3s.adcsCertUtil.ADCSInstanceDetails;
import de.trustable.ca3s.adcsCertUtil.ADCSProxyTLSException;
import de.trustable.ca3s.adcsCertUtil.ADCSProxyUnavailableException;
import de.trustable.ca3s.adcsCertUtil.ADCSWinNativeConnector;
import de.trustable.ca3s.adcsCertUtil.CertificateEnrollmentResponse;
import de.trustable.ca3s.adcsCertUtil.SubmitStatus;
import de.trustable.ca3s.client.api.RemoteADCSClient;
import de.trustable.ca3s.client.invoker.ApiException;
import de.trustable.ca3s.client.model.ADCSInstanceDetailsResponse;
import de.trustable.ca3s.client.model.CertificateRequestElements;
import de.trustable.ca3s.client.model.CertificateRequestElementsAttributes;
import de.trustable.ca3s.client.model.CertificateRevocationRequest;
import de.trustable.ca3s.client.model.GetCertificateResponse;
import de.trustable.ca3s.client.model.GetCertificateResponseValues;
import de.trustable.ca3s.client.model.JWSWrappedRequest;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.ws.rs.ProcessingException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ADCSWinNativeConnectorAdapter
implements ADCSWinNativeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ADCSWinNativeConnectorAdapter.class);
    private RemoteADCSClient remoteClient;
    private byte[] sharedSecret;

    public ADCSWinNativeConnectorAdapter(String caUrl, String secret, TrustManager ca3sTrustManager, String ca3sSalt, int iterations, String apiKeySalt, int apiKeyIterations) throws GeneralSecurityException {
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec specApiKey = new PBEKeySpec(secret.toCharArray(), apiKeySalt.getBytes(), apiKeyIterations, 256);
        PBEKeySpec specSecKey = new PBEKeySpec(secret.toCharArray(), ca3sSalt.getBytes(), iterations, 256);
        this.sharedSecret = skf.generateSecret(specSecKey).getEncoded();
        String apiKey = Base64.encodeBase64String((byte[])skf.generateSecret(specApiKey).getEncoded());
        TrustManager[] trustManagers = new TrustManager[]{ca3sTrustManager};
        this.remoteClient = new RemoteADCSClient(caUrl, apiKey, trustManagers);
        this.remoteClient.getApiClient().setConnectTimeout(30000);
        this.remoteClient.getApiClient().setReadTimeout(60000);
    }

    public CertificateEnrollmentResponse submitRequest(String b64Csr, Map<String, String> attrMap) throws ADCSException {
        CertificateRequestElements cre = new CertificateRequestElements();
        cre.setCsr(b64Csr);
        ArrayList<CertificateRequestElementsAttributes> attributes = new ArrayList<CertificateRequestElementsAttributes>();
        for (String key : attrMap.keySet()) {
            CertificateRequestElementsAttributes crea = new CertificateRequestElementsAttributes();
            crea.setName(key);
            crea.setValue(attrMap.get(key));
            attributes.add(crea);
        }
        cre.setAttributes(attributes);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String payload = objectMapper.writeValueAsString((Object)cre);
            MACSigner signer = new MACSigner(this.sharedSecret);
            JWSObject jwsObject = new JWSObject(new JWSHeader(JWSAlgorithm.HS256), new Payload(payload));
            jwsObject.sign((JWSSigner)signer);
            JWSWrappedRequest jwsRequest = new JWSWrappedRequest();
            jwsRequest.setJws(jwsObject.serialize());
            LOGGER.debug("calling ADCSProxy with JWS: " + jwsRequest);
            de.trustable.ca3s.client.model.CertificateEnrollmentResponse response = this.remoteClient.buildCertificate(jwsRequest);
            CertificateEnrollmentResponse resp = new CertificateEnrollmentResponse();
            resp.setReqId((long)response.getReqId().intValue());
            resp.setStatus(SubmitStatus.valueOf((String)response.getStatus()));
            resp.setB64Cert(response.getCert());
            resp.setB64CACert(response.getCertCA());
            return resp;
        }
        catch (ApiException e) {
            if (e.getCode() == 503) {
                throw new ADCSProxyUnavailableException(e.getLocalizedMessage());
            }
            LOGGER.warn("ADCSException : " + e.getCode(), (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOGGER.warn("IOException writing JSON object ", (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        catch (JOSEException e) {
            LOGGER.warn("JOSEException writing JSON object ", (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
    }

    public void revokeCertifcate(String serial, int reason, Date revocationDate) throws ADCSException {
        try {
            CertificateRevocationRequest crr = new CertificateRevocationRequest();
            crr.serial(serial);
            crr.setReason(Integer.valueOf(reason));
            crr.setRevTime(revocationDate.getTime());
            ObjectMapper objectMapper = new ObjectMapper();
            String payload = objectMapper.writeValueAsString((Object)crr);
            MACSigner signer = new MACSigner(this.sharedSecret);
            JWSObject jwsObject = new JWSObject(new JWSHeader(JWSAlgorithm.HS256), new Payload(payload));
            jwsObject.sign((JWSSigner)signer);
            JWSWrappedRequest jwsRequest = new JWSWrappedRequest();
            jwsRequest.setJws(jwsObject.serialize());
            LOGGER.debug("calling ADCSProxy with JWS: " + jwsRequest);
            this.remoteClient.revokeCertificate(jwsRequest);
        }
        catch (ApiException e) {
            if (e.getCode() == 503) {
                throw new ADCSProxyUnavailableException(e.getLocalizedMessage());
            }
            LOGGER.warn("ACDSException : " + e.getCode(), (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOGGER.warn("IOException writing JSON object ", (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        catch (JOSEException e) {
            LOGGER.warn("JOSEException writing JSON object ", (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
    }

    public List<String> getRequesIdList(int limit, int offset, long resolvedWhenTimestamp, long revokedEffectiveWhen) throws ADCSException {
        try {
            List rir = this.remoteClient.getRequestIdList(Integer.valueOf(offset), Long.valueOf(resolvedWhenTimestamp), Long.valueOf(revokedEffectiveWhen), Integer.valueOf(limit));
            return rir;
        }
        catch (ApiException e) {
            if (e.getCode() == 503) {
                throw new ADCSProxyUnavailableException(e.getLocalizedMessage());
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new ADCSProxyUnavailableException(e.getCause().getMessage());
            }
            LOGGER.warn("ADCSException : " + e.getCode(), (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
    }

    public de.trustable.ca3s.adcsCertUtil.GetCertificateResponse getCertificateByRequestId(String reqId) throws ADCSException {
        try {
            GetCertificateResponse gcr = this.remoteClient.getRequestById(reqId);
            de.trustable.ca3s.adcsCertUtil.GetCertificateResponse resp = new de.trustable.ca3s.adcsCertUtil.GetCertificateResponse();
            if (gcr.getValues() != null) {
                for (GetCertificateResponseValues value : gcr.getValues()) {
                    if ("ReqId".equals(value.getName())) {
                        resp.setReqId(value.getValue());
                        continue;
                    }
                    if ("Template".equals(value.getName())) {
                        resp.setTemplate(value.getValue());
                        continue;
                    }
                    if ("Cert".equals(value.getName())) {
                        resp.setB64Cert(value.getValue());
                        continue;
                    }
                    if ("ResolvedDate".equals(value.getName())) {
                        resp.setResolvedDate(value.getValue());
                        continue;
                    }
                    if ("RevokedDate".equals(value.getName())) {
                        resp.setRevokedDate(value.getValue());
                        continue;
                    }
                    if ("RevokedReason".equals(value.getName())) {
                        resp.setRevokedReason(value.getValue());
                        continue;
                    }
                    if ("Disposition".equals(value.getName())) {
                        resp.setDisposition(value.getValue());
                        continue;
                    }
                    if (!"DispositionMessage".equals(value.getName())) continue;
                    resp.setDispositionMessage(value.getValue());
                }
            }
            return resp;
        }
        catch (ApiException e) {
            if (e.getCode() == 503) {
                throw new ADCSProxyUnavailableException(e.getLocalizedMessage());
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new ADCSProxyUnavailableException(e.getCause().getMessage());
            }
            LOGGER.warn("ADCSException : " + e.getCode(), (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
    }

    public String getInfo() throws ADCSException {
        try {
            return this.remoteClient.getADCSInfo();
        }
        catch (ProcessingException pe) {
            if (pe.getCause() instanceof SSLException) {
                LOGGER.info("info call for ADCS proxy did not succeeded! Trying later ...");
                throw new ADCSProxyUnavailableException("connection problem accessing ca : " + pe.getCause().getLocalizedMessage());
            }
            throw pe;
        }
        catch (ApiException e) {
            if (e.getCause() instanceof ConnectException) {
                LOGGER.info("info call for ADCS proxy did not succeeded! Trying later ...");
                throw new ADCSProxyUnavailableException("connection problem accessing ca : " + e.getCause().getLocalizedMessage());
            }
            if (e.getCause() instanceof ConnectException) {
                LOGGER.info("info call for ADCS proxy did not succeeded! Trying later ...");
                throw new ADCSProxyUnavailableException("connection problem accessing ca : " + e.getCause().getLocalizedMessage());
            }
            if (e.getCode() == 503) {
                throw new ADCSProxyUnavailableException(e.getLocalizedMessage());
            }
            if (e.getCode() == 401) {
                LOGGER.info("info call rejected by ADCS proxy. Authentication wrong or missing.");
                throw new ADCSProxyUnavailableException(e.getLocalizedMessage());
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                LOGGER.info("info call to ADCS proxy timed out.", e.getCause());
                throw new ADCSProxyUnavailableException(e.getCause().getMessage());
            }
            if (e.getCause() instanceof ConnectException) {
                LOGGER.warn("Connection problem", e.getCause());
                throw new ADCSProxyUnavailableException(e.getCause().getMessage());
            }
            if (e.getCause() instanceof SSLHandshakeException) {
                String msg = "TLS problem : configure trust anchor for ADCS proxy at " + this.remoteClient.getApiClient().getBasePath();
                LOGGER.debug(msg, (Throwable)e);
                LOGGER.warn(msg);
                throw new ADCSProxyTLSException(msg);
            }
            LOGGER.warn("ADCSException : " + e.getCode(), (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
    }

    public String[] getCATemplates() throws ADCSException {
        String[] templateArr = new String[]{"FooTemplate"};
        return templateArr;
    }

    public ADCSInstanceDetails getCAInstanceDetails() throws ADCSException {
        ADCSInstanceDetails details = new ADCSInstanceDetails();
        try {
            ADCSInstanceDetailsResponse detailsResp = this.remoteClient.getCAInstanceDetails();
            details.setCaName(detailsResp.getCaName());
            details.setCaType(detailsResp.getCaType());
            details.setDnsName(detailsResp.getDnsName());
            details.setFileVersion(detailsResp.getFileVersion());
            details.setParentCaName(detailsResp.getParentCaName());
            details.setProductVersion(detailsResp.getProductVersion());
            details.setSigningCertChains(this.fromList(detailsResp.getSigningCertChains()));
            details.setSigningCerts(this.fromList(detailsResp.getSigningCerts()));
            details.setSubjectTemplateOIDs(this.fromList(detailsResp.getSubjectTemplateOIDs()));
            details.setTemplates(this.fromList(detailsResp.getTemplates()));
        }
        catch (ApiException e) {
            if (e.getCode() == 503) {
                throw new ADCSProxyUnavailableException(e.getLocalizedMessage());
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new ADCSProxyUnavailableException(e.getCause().getMessage());
            }
            if (e.getCause() instanceof ConnectException) {
                LOGGER.warn("Connection problem", (Throwable)e);
                throw new ADCSProxyUnavailableException(e.getCause().getMessage());
            }
            if (e.getCause() instanceof SSLHandshakeException) {
                LOGGER.warn("TLS problem : configure trust anchor for ADCS proxy at " + this.remoteClient.getApiClient().getBasePath());
                throw new ADCSProxyTLSException(e.getCause().getMessage());
            }
            LOGGER.warn("ADCSException : " + e.getCode(), (Throwable)e);
            throw new ADCSException(e.getLocalizedMessage());
        }
        return details;
    }

    String[] fromList(List<String> list) {
        String[] retArr = new String[list.size()];
        return list.toArray(retArr);
    }
}

