/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.User;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;
import tech.jhipster.config.JHipsterProperties;

@Service
public class MailService {
    private final Logger log = LoggerFactory.getLogger(MailService.class);
    private static final String USER = "user";
    private static final String BASE_URL = "baseUrl";
    private final JHipsterProperties jHipsterProperties;
    private final JavaMailSender javaMailSender;
    private final MessageSource messageSource;
    private final SpringTemplateEngine templateEngine;

    public MailService(JHipsterProperties jHipsterProperties, JavaMailSender javaMailSender, MessageSource messageSource, SpringTemplateEngine templateEngine) {
        this.jHipsterProperties = jHipsterProperties;
        this.javaMailSender = javaMailSender;
        this.messageSource = messageSource;
        this.templateEngine = templateEngine;
    }

    @Transactional
    public void sendEmail(String to, String[] cc, String subject, String content, boolean isMultipart, boolean isHtml) throws MessagingException {
        this.log.debug("Send email[multipart' '{}' and html '{}'] to '{}' (cc to '{}') with subject '{}' and content={}", new Object[]{isMultipart, isHtml, to, cc, subject, content});
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, isMultipart, StandardCharsets.UTF_8.name());
        message.setTo(to);
        if (cc != null) {
            message.setCc(cc);
        }
        if (this.jHipsterProperties.getMail() != null && this.jHipsterProperties.getMail().getFrom() != null && !this.jHipsterProperties.getMail().getFrom().isEmpty()) {
            message.setFrom(this.jHipsterProperties.getMail().getFrom());
        } else {
            this.log.warn("Email 'from' address not set for email delivery! Consider defining a useful sender address.");
            message.setFrom("ca3s@localhost");
        }
        message.setSubject(subject);
        message.setText(content, isHtml);
        this.javaMailSender.send(mimeMessage);
        this.log.debug("Sent email to User '{}'", (Object)to);
    }

    @Transactional
    public void sendEmailFromTemplate(Context context, User user, String email, String[] cc, String templateName, String titleKey) throws MessagingException {
        this.sendEmailFromTemplate(context, user, email, cc, templateName, titleKey, null);
    }

    @Transactional
    public void sendEmailFromTemplate(Context context, User user, String[] cc, String templateName, String titleKey) throws MessagingException {
        this.sendEmailFromTemplate(context, user, user.getEmail(), cc, templateName, titleKey, null);
    }

    public void sendEmailFromTemplate(Context context, User user, String[] cc, String templateName, String titleKey, String[] args) throws MessagingException {
        this.sendEmailFromTemplate(context, user, user.getEmail(), cc, templateName, titleKey, args);
    }

    @Transactional
    public void sendEmailFromTemplate(Context context, User user, String email, String[] cc, String templateName, String titleKey, String[] args) throws MessagingException {
        if (user != null) {
            context.setVariable(USER, (Object)user);
        }
        if (this.jHipsterProperties.getMail() != null && this.jHipsterProperties.getMail().getBaseUrl() != null && !this.jHipsterProperties.getMail().getBaseUrl().isEmpty()) {
            context.setVariable(BASE_URL, (Object)this.jHipsterProperties.getMail().getBaseUrl());
        } else {
            this.log.warn("baseUrl not set for email templates");
            context.setVariable(BASE_URL, (Object)"/");
        }
        context.setVariable(BASE_URL, (Object)this.jHipsterProperties.getMail().getBaseUrl());
        String content = this.getContent(templateName, context);
        String subject = this.messageSource.getMessage(titleKey, (Object[])args, context.getLocale());
        this.sendEmail(email, cc, subject, content, false, true);
    }

    @Transactional
    public void sendEmailFromTemplate(User user, String templateName, String titleKey) throws MessagingException {
        if (user.getEmail() == null) {
            this.log.debug("Email doesn't exist for user '{}'", (Object)user.getLogin());
            return;
        }
        Locale locale = Locale.forLanguageTag(user.getLangKey());
        Context context = new Context(locale);
        context.setVariable(USER, (Object)user);
        context.setVariable(BASE_URL, (Object)this.jHipsterProperties.getMail().getBaseUrl());
        String content = this.getContent(templateName, context);
        String subject = this.messageSource.getMessage(titleKey, null, locale);
        this.sendEmail(user.getEmail(), null, subject, content, false, true);
    }

    private String getContent(String templateName, Context context) {
        return this.templateEngine.process(templateName, (IContext)context);
    }

    public void sendActivationEmail(User user) throws MessagingException {
        this.log.debug("Sending activation email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/activationEmail", "email.activation.title");
    }

    public void sendCreationEmail(User user) throws MessagingException {
        this.log.debug("Sending creation email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/creationEmail", "email.activation.title");
    }

    public void sendPasswordResetMail(User user) throws MessagingException {
        this.log.debug("Sending password reset email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/passwordResetEmail", "email.reset.title");
    }
}

