/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import tech.jhipster.config.JHipsterProperties;

@Component
public class TokenProvider {
    private final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    private static final String AUTHORITIES_KEY = "auth";
    private static final String SKI_KEY = "ski";
    private final long tokenValiditySKIInMilliseconds = 60000L;
    private final Key key;
    private final JwtParser jwtParser;
    private final long tokenValidityInMilliseconds;
    private final long tokenValidityInMillisecondsForRememberMe;

    public TokenProvider(JHipsterProperties jHipsterProperties) {
        byte[] keyBytes;
        String secret = jHipsterProperties.getSecurity().getAuthentication().getJwt().getBase64Secret();
        if (!ObjectUtils.isEmpty((Object)secret)) {
            this.log.debug("Using a Base64-encoded JWT secret key");
            keyBytes = (byte[])Decoders.BASE64.decode((Object)secret);
        } else {
            this.log.warn("Warning: the JWT key used is not Base64-encoded. We recommend using the `jhipster.security.authentication.jwt.base64-secret` key for optimum security.");
            secret = jHipsterProperties.getSecurity().getAuthentication().getJwt().getSecret();
            keyBytes = secret.getBytes(StandardCharsets.UTF_8);
        }
        this.key = Keys.hmacShaKeyFor((byte[])keyBytes);
        this.jwtParser = Jwts.parserBuilder().setSigningKey(this.key).build();
        this.tokenValidityInMilliseconds = 1000L * jHipsterProperties.getSecurity().getAuthentication().getJwt().getTokenValidityInSeconds();
        this.tokenValidityInMillisecondsForRememberMe = 1000L * jHipsterProperties.getSecurity().getAuthentication().getJwt().getTokenValidityInSecondsForRememberMe();
    }

    public String createToken(Authentication authentication, boolean rememberMe) {
        String authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
        long now = new Date().getTime();
        Date validity = rememberMe ? new Date(now + this.tokenValidityInMillisecondsForRememberMe) : new Date(now + this.tokenValidityInMilliseconds);
        return Jwts.builder().setSubject(authentication.getName()).claim(AUTHORITIES_KEY, (Object)authorities).signWith(this.key, SignatureAlgorithm.HS512).setExpiration(validity).compact();
    }

    public String createToken(String subject, String b46Ski) {
        long now = new Date().getTime();
        Date validity = new Date(now + 60000L);
        return Jwts.builder().setSubject(subject).claim(SKI_KEY, (Object)b46Ski).signWith(this.key, SignatureAlgorithm.HS512).setExpiration(validity).compact();
    }

    public Authentication getAuthentication(String token) {
        Claims claims = (Claims)this.jwtParser.parseClaimsJws(token).getBody();
        Collection authorities = Arrays.stream(claims.get((Object)AUTHORITIES_KEY).toString().split(",")).filter(auth -> !auth.trim().isEmpty()).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        User principal = new User(claims.getSubject(), "", authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)token, authorities);
    }

    public boolean validateToken(String authToken) {
        try {
            this.jwtParser.parseClaimsJws(authToken);
            return true;
        }
        catch (JwtException | IllegalArgumentException e) {
            this.log.info("Invalid JWT token.");
            this.log.trace("Invalid JWT token trace.", e);
            return false;
        }
    }
}

