/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CSRUtil;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ProtectedContentCleanupScheduler {
    transient Logger LOG = LoggerFactory.getLogger(ProtectedContentCleanupScheduler.class);
    private final int maxRecordsPerTransaction;
    private final ProtectedContentRepository protectedContentRepository;
    private final CSRRepository csrRepository;
    private final CSRUtil csrUtil;
    private final AuditService auditService;

    public ProtectedContentCleanupScheduler(@Value(value="${ca3s.batch.maxRecordsPerTransaction:1000}") int maxRecordsPerTransaction, ProtectedContentRepository protectedContentRepository, CSRRepository csrRepository, CSRUtil csrUtil, AuditService auditService) {
        this.protectedContentRepository = protectedContentRepository;
        this.csrRepository = csrRepository;
        this.csrUtil = csrUtil;
        this.auditService = auditService;
        this.maxRecordsPerTransaction = maxRecordsPerTransaction;
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.protectedContentCleanup:600000}")
    public void runMinute() {
        Instant now = Instant.now();
        Page invalidList = this.protectedContentRepository.findByValidToPassed((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction), now);
        for (ProtectedContent pc : invalidList) {
            CSR csr;
            Optional optCsr;
            if (!ContentRelationType.CSR.equals((Object)pc.getRelationType()) || !(optCsr = this.csrRepository.findById((Object)pc.getRelatedId())).isPresent() || !CsrStatus.PENDING.equals((Object)(csr = (CSR)optCsr.get()).getStatus())) continue;
            this.csrUtil.setStatusAndRejectionReason(csr, CsrStatus.REJECTED, "created key for csr expired");
            this.auditService.createAuditTraceCsrRejected(csr, "created key for csr expired");
        }
        Page expiredList = this.protectedContentRepository.findByDeleteAfterPassed((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction), now);
        if (!expiredList.isEmpty()) {
            this.LOG.info("deleting #{} expired ProtectedContent objects", (Object)expiredList.getNumberOfElements());
            for (ProtectedContent pc : invalidList) {
                this.LOG.debug("delete protected content due to passed deletion date: {}", (Object)pc);
            }
            this.protectedContentRepository.deleteAll((Iterable)expiredList);
        }
    }
}

