/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import java.util.concurrent.Executor;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import tech.jhipster.config.liquibase.SpringLiquibaseUtil;

@Configuration
public class LiquibaseConfiguration {
    private final Logger log = LoggerFactory.getLogger(LiquibaseConfiguration.class);
    private final Environment env;
    private final String changeLogPath;

    public LiquibaseConfiguration(Environment env, @Value(value="${spring.liquibase.change-log:classpath:config/liquibase/master.xml}") String changeLogPath, @Value(value="${spring.datasource.url:}") String datasourceUrl) {
        this.env = env;
        if (datasourceUrl != null && datasourceUrl.toLowerCase().startsWith("jdbc:sqlserver") && changeLogPath.equalsIgnoreCase("classpath:config/liquibase/master.xml")) {
            this.changeLogPath = "classpath:config/liquibase-mssql/master.xml";
            this.log.info("liquibase path adapted for mssql: {}", (Object)changeLogPath);
        } else {
            this.changeLogPath = changeLogPath;
        }
    }

    @Bean
    public SpringLiquibase liquibase(@Qualifier(value="taskExecutor") Executor executor, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource, LiquibaseProperties liquibaseProperties, ObjectProvider<DataSource> dataSource, DataSourceProperties dataSourceProperties) {
        SpringLiquibase liquibase = SpringLiquibaseUtil.createSpringLiquibase((DataSource)((DataSource)liquibaseDataSource.getIfAvailable()), (LiquibaseProperties)liquibaseProperties, (DataSource)((DataSource)dataSource.getIfUnique()), (DataSourceProperties)dataSourceProperties);
        liquibase.setChangeLog(this.changeLogPath);
        liquibase.setContexts(liquibaseProperties.getContexts());
        liquibase.setDefaultSchema(liquibaseProperties.getDefaultSchema());
        liquibase.setLiquibaseSchema(liquibaseProperties.getLiquibaseSchema());
        liquibase.setLiquibaseTablespace(liquibaseProperties.getLiquibaseTablespace());
        liquibase.setDatabaseChangeLogLockTable(liquibaseProperties.getDatabaseChangeLogLockTable());
        liquibase.setDatabaseChangeLogTable(liquibaseProperties.getDatabaseChangeLogTable());
        liquibase.setDropFirst(liquibaseProperties.isDropFirst());
        liquibase.setLabels(liquibaseProperties.getLabels());
        liquibase.setChangeLogParameters(liquibaseProperties.getParameters());
        liquibase.setRollbackFile(liquibaseProperties.getRollbackFile());
        liquibase.setTestRollbackOnUpdate(liquibaseProperties.isTestRollbackOnUpdate());
        if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{"no-liquibase"}))) {
            liquibase.setShouldRun(false);
        } else {
            liquibase.setShouldRun(liquibaseProperties.isEnabled());
            this.log.debug("Configuring Liquibase");
        }
        return liquibase;
    }
}

