/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class PropertiesLogger
implements ApplicationListener<ApplicationPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(PropertiesLogger.class);
    private ConfigurableEnvironment environment;
    private boolean isFirstRun = true;

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        if (this.isFirstRun) {
            this.environment = event.getApplicationContext().getEnvironment();
            this.printProperties();
        }
        this.isFirstRun = false;
    }

    public void printProperties() {
        if (log.isDebugEnabled()) {
            for (EnumerablePropertySource propertySource : this.findPropertiesPropertySources()) {
                log.debug("******* " + propertySource.getName() + " *******");
                Object[] propertyNames = propertySource.getPropertyNames();
                Arrays.sort(propertyNames);
                for (Object propertyName : propertyNames) {
                    String sourceProperty;
                    String resolvedProperty = this.environment.getProperty((String)propertyName);
                    if (resolvedProperty.equals(sourceProperty = propertySource.getProperty((String)propertyName).toString())) {
                        log.debug("{}={}", propertyName, (Object)resolvedProperty);
                        continue;
                    }
                    log.debug("{}={} OVERRIDDEN to {}", new Object[]{propertyName, sourceProperty, resolvedProperty});
                }
            }
        }
    }

    private List<EnumerablePropertySource> findPropertiesPropertySources() {
        LinkedList<EnumerablePropertySource> propertiesPropertySources = new LinkedList<EnumerablePropertySource>();
        for (PropertySource propertySource : this.environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            propertiesPropertySources.add((EnumerablePropertySource)propertySource);
        }
        return propertiesPropertySources;
    }
}

