package de.trustable.ca3s.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class PropertiesLogger implements ApplicationListener<ApplicationPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(PropertiesLogger.class);

    private ConfigurableEnvironment environment;
    private boolean isFirstRun = true;

    @Override
    public void onApplicationEvent(ApplicationPreparedEvent event) {
        if (isFirstRun) {
            environment = event.getApplicationContext().getEnvironment();
            printProperties();
        }
        isFirstRun = false;
    }

    public void printProperties() {
        if(log.isDebugEnabled()) {
            for (EnumerablePropertySource propertySource : findPropertiesPropertySources()) {
                log.debug("******* " + propertySource.getName() + " *******");
                String[] propertyNames = propertySource.getPropertyNames();
                Arrays.sort(propertyNames);
                for (String propertyName : propertyNames) {
                    String resolvedProperty = environment.getProperty(propertyName);
                    String sourceProperty = propertySource.getProperty(propertyName).toString();
                    if (resolvedProperty.equals(sourceProperty)) {
                        log.debug("{}={}", propertyName, resolvedProperty);
                    } else {
                        log.debug("{}={} OVERRIDDEN to {}", propertyName, sourceProperty, resolvedProperty);
                    }
                }
            }
        }
    }

    private List<EnumerablePropertySource> findPropertiesPropertySources() {
        List<EnumerablePropertySource> propertiesPropertySources = new LinkedList<>();
        for (PropertySource<?> propertySource : environment.getPropertySources()) {
            if (propertySource instanceof EnumerablePropertySource) {
                propertiesPropertySources.add((EnumerablePropertySource) propertySource);
            }
        }
        return propertiesPropertySources;
    }
}
