/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.dto.NamedValues;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.dto.acme.FinalizeRequest;
import de.trustable.ca3s.core.service.dto.acme.OrderResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.ACMEUtil;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.JwtUtil;
import de.trustable.ca3s.core.web.rest.acme.ACMEController;
import de.trustable.util.CryptoUtil;
import de.trustable.util.OidNameMapper;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Transactional
@Controller
@RequestMapping(value={"/acme/{realm}/order"})
public class OrderController
extends ACMEController {
    private static final Logger LOG = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private AcmeOrderRepository orderRepository;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private CertificateProcessingUtil cpUtil;

    @RequestMapping(value={"/{orderId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> postAsGetOrder(@RequestBody String requestBody, @PathVariable long orderId, @PathVariable String realm) {
        LOG.info("Received read order request for orderId {}", (Object)orderId);
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            List orderList = this.orderRepository.findByOrderId(orderId);
            if (orderList.isEmpty()) {
                LOG.debug("reading attempt for non-existing orderId {}", (Object)orderId);
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeOrder orderDao = (AcmeOrder)orderList.get(0);
            if (!orderDao.getAccount().equals((Object)acctDao)) {
                LOG.error("Account idenfied by key (accound {}) does not match account {} of requested order", (Object)acctDao, (Object)orderDao.getAccount());
                return ResponseEntity.badRequest().build();
            }
            UriComponentsBuilder baseUriBuilder = ServletUriComponentsBuilder.fromCurrentRequestUri().path("../../..");
            LOG.debug("postAsGetOrder: baseUriBuilder : " + baseUriBuilder.toUriString());
            return this.buildOrderResponse(additionalHeaders, orderDao, baseUriBuilder, true);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    @RequestMapping(value={"/finalize/{orderId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> finalizeOrder(@RequestBody String requestBody, @PathVariable long orderId, @PathVariable String realm) {
        LOG.info("Received finalize order request ");
        Pipeline pipeline = this.getPipelineForRealm(realm);
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            FinalizeRequest finalizeReq = this.jwtUtil.getFinalizeReq(context.getJwtClaims());
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            String csrAsString = finalizeReq.getCsr();
            LOG.debug("csr received: " + csrAsString);
            byte[] csrByte = Base64Url.decode((String)csrAsString);
            Pkcs10RequestHolder p10Holder = this.cryptoUtil.parseCertificateRequest(csrByte);
            LOG.debug("csr decoded: " + p10Holder);
            HashSet<String> snSet = new HashSet<String>();
            for (RDN rDN : p10Holder.getSubjectRDNs()) {
                for (AttributeTypeAndValue atv : rDN.getTypesAndValues()) {
                    if (!BCStyle.CN.equals((ASN1Primitive)atv.getType())) continue;
                    String cnValue = atv.getValue().toString();
                    LOG.debug("cn found in CSR: " + cnValue);
                    snSet.add(cnValue);
                }
            }
            for (RDN rDN : p10Holder.getReqAttributes()) {
                Iterator attrOid = rDN.getAttrType().getId();
                String attrReadableName = OidNameMapper.lookupOid((String)((Object)attrOid));
                if (PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)rDN.getAttrType())) {
                    LOG.debug("CSR contains extensionRequest");
                    this.retrieveSANFromCSRAttribute(snSet, (Attribute)rDN);
                    continue;
                }
                if ("certReqExtensions".equals(attrReadableName)) {
                    LOG.debug("CSR contains attrReadableName");
                    this.retrieveSANFromCSRAttribute(snSet, (Attribute)rDN);
                    continue;
                }
                String value = this.getASN1ValueAsString((Attribute)rDN);
                LOG.debug("found attrReadableName '{}' with value '{}'", (Object)attrReadableName, (Object)value);
            }
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            List orderList = this.orderRepository.findByOrderId(orderId);
            if (orderList.isEmpty()) {
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeOrder orderDao = (AcmeOrder)orderList.get(0);
            if (!orderDao.getAccount().equals((Object)acctDao)) {
                LOG.error("Account idenfied by key (accound {}) does not match account {} of requested order", (Object)acctDao, (Object)orderDao.getAccount());
                return ResponseEntity.badRequest().build();
            }
            if (orderDao.getStatus() == AcmeOrderStatus.PENDING || orderDao.getStatus() == AcmeOrderStatus.PROCESSING) {
                if (orderDao.getExpires().isBefore(Instant.now())) {
                    LOG.debug("pending order {} expired on {}", (Object)orderDao.getOrderId(), (Object)orderDao.getExpires().toString());
                    orderDao.setStatus(AcmeOrderStatus.INVALID);
                } else {
                    boolean bl;
                    boolean bl2;
                    boolean bl3 = true;
                    for (String san : snSet) {
                        boolean bSanFound = false;
                        for (AcmeAuthorization authDao : orderDao.getAcmeAuthorizations()) {
                            if (!san.equalsIgnoreCase(authDao.getValue())) continue;
                            LOG.debug("san '{}' part of order {} in authorization {}", new Object[]{san, orderDao.getOrderId(), authDao.toString()});
                            bSanFound = true;
                            break;
                        }
                        if (bSanFound) continue;
                        LOG.info("failed to find requested hostname '{}' (from CSR) in authorization", (Object)san);
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        for (AcmeAuthorization authDao : orderDao.getAcmeAuthorizations()) {
                            boolean authReady = false;
                            for (AcmeChallenge challDao : authDao.getChallenges()) {
                                if (challDao.getStatus() != ChallengeStatus.VALID) continue;
                                LOG.debug("challenge {} of type {} is valid ", (Object)challDao.getChallengeId(), (Object)challDao.getType());
                                authReady = true;
                                break;
                            }
                            if (authReady) {
                                LOG.debug("found valid challenge, authorization id {} is valid ", (Object)authDao.getAcmeAuthorizationId());
                                continue;
                            }
                            LOG.debug("no valid challange, authorization id {} and order {} fails ", (Object)authDao.getAcmeAuthorizationId(), (Object)orderDao.getOrderId());
                            bl = false;
                            break;
                        }
                    }
                    if (bl) {
                        LOG.debug("order status {} changes to ready for order {}", (Object)orderDao.getStatus(), (Object)orderDao.getOrderId());
                        orderDao.setStatus(AcmeOrderStatus.READY);
                        LOG.debug("order {} status 'ready', producing certificate", (Object)orderDao.getOrderId());
                        this.startCertificateCreationProcess(orderDao, pipeline, "ACME_ACCOUNT_" + acctDao.getAccountId(), CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)p10Holder.getP10Req()));
                        this.orderRepository.save((Object)orderDao);
                    } else {
                        orderDao.setStatus(AcmeOrderStatus.INVALID);
                    }
                }
            } else {
                LOG.debug("unexpected finalize call at order status {} for order {}", (Object)orderDao.getStatus(), (Object)orderDao.getOrderId());
            }
            if (orderDao.getStatus() == AcmeOrderStatus.READY && orderDao.getCertificate() == null) {
                LOG.debug("order {} status 'ready', producing certificate", (Object)orderDao.getOrderId());
            }
            boolean bl = true;
            UriComponentsBuilder baseUriBuilder = ServletUriComponentsBuilder.fromCurrentRequestUri().path("../../../..");
            LOG.debug("finalize: baseUriBuilder : " + baseUriBuilder.toUriString());
            return this.buildOrderResponse(additionalHeaders, orderDao, baseUriBuilder, bl);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
        catch (IOException | GeneralSecurityException e) {
            ProblemDetail problem = new ProblemDetail(ACMEUtil.SERVER_INTERNAL, "Algorithm mismatch.", HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE);
            return this.buildProblemResponseEntity(new AcmeProblemException(problem));
        }
    }

    private ResponseEntity<OrderResponse> buildOrderResponse(HttpHeaders additionalHeaders, AcmeOrder orderDao, UriComponentsBuilder baseUriBuilder, boolean valid) {
        HashSet<String> authorizationsResp = new HashSet<String>();
        for (AcmeAuthorization authDao : orderDao.getAcmeAuthorizations()) {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)baseUriBuilder.build().normalize().toUri());
            LOG.debug("uriBuilder: {}", (Object)uriBuilder.toUriString());
            UriComponentsBuilder uriBuilderOrder = uriBuilder.path(this.ORDER_RESOURCE_MAPPING);
            LOG.debug("uriBuilderOrder: {}", (Object)uriBuilderOrder.toUriString());
            String authUrl = this.locationUriOfAuth(authDao.getAcmeAuthorizationId().longValue(), uriBuilderOrder).toString();
            authorizationsResp.add(authUrl);
            LOG.debug("authUrl: {}", (Object)authUrl);
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)baseUriBuilder.build().normalize().toUri());
        String finalizeUrl = uriBuilder.path(this.ORDER_RESOURCE_MAPPING).path("/finalize/").path(Long.toString(orderDao.getOrderId())).build().toUriString();
        LOG.debug("order request finalize url: {}", (Object)finalizeUrl);
        String certificateUrl = null;
        if (orderDao.getCertificate() != null) {
            long certId = orderDao.getCertificate().getId();
            uriBuilder = UriComponentsBuilder.fromUri((URI)baseUriBuilder.build().normalize().toUri());
            certificateUrl = uriBuilder.path(this.CERTIFICATE_RESOURCE_MAPPING).path("/").path(Long.toString(certId)).build().toUriString();
            LOG.debug("order request cert url: {}", (Object)certificateUrl);
        }
        OrderResponse orderResp = new OrderResponse(orderDao, authorizationsResp, finalizeUrl, certificateUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("order response for verified request: {}", (Object)this.jwtUtil.getOrderResponseAsJSON(orderResp));
        }
        if (valid) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)orderResp);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)orderResp);
    }

    private Certificate startCertificateCreationProcess(AcmeOrder orderDao, Pipeline pipeline, String requestorName, String csrAsPem) {
        NamedValues[] nvArr = new NamedValues[0];
        ArrayList messageList = new ArrayList();
        CSR csr = this.cpUtil.buildCSR(csrAsPem, requestorName, "ACME_CERTIFICATE_REQUESTED", "", pipeline, nvArr, messageList);
        if (csr == null) {
            LOG.info("building CSR failed");
            String msg = "";
            if (!messageList.isEmpty()) {
                msg = (String)messageList.get(0);
            }
            ProblemDetail problem = new ProblemDetail(ACMEUtil.BAD_CSR, msg, HttpStatus.BAD_REQUEST, "", ACMEController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        Certificate cert = this.cpUtil.processCertificateRequest(csr, requestorName, "ACME_CERTIFICATE_CREATED", pipeline);
        if (cert == null) {
            orderDao.setStatus(AcmeOrderStatus.INVALID);
            LOG.warn("creation of certificate by ACME order {} failed ", (Object)orderDao.getOrderId());
        } else {
            LOG.debug("updating order id {} with new certificate id {}", (Object)orderDao.getOrderId(), (Object)cert.getId());
            orderDao.setCertificate(cert);
            orderDao.setStatus(AcmeOrderStatus.VALID);
            LOG.debug("adding certificate attribute 'ACME_ACCOUNT_ID' {} for certificate id {}", (Object)orderDao.getAccount().getAccountId(), (Object)cert.getId());
            this.certUtil.setCertAttribute(cert, "ACME:ACCOUNT_ID", orderDao.getAccount().getAccountId().longValue());
            this.certUtil.setCertAttribute(cert, "ACME:ORDER_ID", orderDao.getOrderId().longValue());
        }
        return cert;
    }

    private String getASN1ValueAsString(Attribute attr) {
        return this.getASN1ValueAsString(attr.getAttrValues().toArray());
    }

    private String getASN1ValueAsString(ASN1Encodable[] asn1EncArr) {
        String value = "";
        for (ASN1Encodable asn1Enc : asn1EncArr) {
            if (value.length() > 0) {
                value = value + ", ";
            }
            value = value + asn1Enc.toString();
        }
        return value;
    }

    private void retrieveSANFromCSRAttribute(Set<String> sanSet, Attribute attrExtension) {
        HashSet generalNameSet = new HashSet();
        CSRUtil.retrieveSANFromCSRAttribute(generalNameSet, (Attribute)attrExtension);
        for (GeneralName gn : generalNameSet) {
            sanSet.add(gn.getName().toString());
        }
    }
}

