/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.UserPreference;
import de.trustable.ca3s.core.service.UserPreferenceService;
import de.trustable.ca3s.core.service.dto.Preferences;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import io.github.jhipster.web.util.HeaderUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin"})
public class PreferenceResource {
    private final Logger log = LoggerFactory.getLogger(PreferenceResource.class);
    @Autowired
    private PreferenceUtil preferenceUtil;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private static final String ENTITY_NAME = "preference";
    private final UserPreferenceService userPreferenceService;

    public PreferenceResource(UserPreferenceService userPreferenceService) {
        this.userPreferenceService = userPreferenceService;
    }

    @GetMapping(value={"/preference/{userId}"})
    public ResponseEntity<Preferences> getPreference(@PathVariable Long userId) {
        Preferences prefs = this.preferenceUtil.getPrefs(userId);
        return new ResponseEntity((Object)prefs, HttpStatus.OK);
    }

    @PutMapping(value={"/preference/{userId}"})
    public ResponseEntity<Preferences> updatePreference(@Valid @RequestBody Preferences preferences, @PathVariable Long userId) {
        this.log.debug("REST request to update Preferences for user {} : {}", (Object)userId, (Object)preferences);
        Preferences oldPrefs = this.preferenceUtil.getPrefs(userId);
        if (preferences.getAcmeHTTP01TimeoutMilliSec() < 100L || preferences.getAcmeHTTP01TimeoutMilliSec() > 60000L) {
            this.log.warn("unexpected Preference value for ACME_HTTP01_TIMEOUT_MILLI_SEC '{}'", (Object)preferences.getAcmeHTTP01TimeoutMilliSec());
            return ResponseEntity.badRequest().build();
        }
        int[] portsArr = preferences.getAcmeHTTP01CallbackPortArr();
        if (portsArr.length == 0 || portsArr.length > 10) {
            this.log.warn("unexpected Preference number for ACME_HTTP01_CALLBACK_PORTS '{}'", (Object)portsArr.length);
            return ResponseEntity.badRequest().body((Object)oldPrefs);
        }
        String portsCommaSeparatedList = "";
        for (int nPort : portsArr) {
            try {
                if (nPort <= 0 || nPort > 65535) {
                    this.log.warn("unexpected Preference value for port in ACME_HTTP01_CALLBACK_PORTS '{}'", (Object)nPort);
                    return ResponseEntity.badRequest().body((Object)oldPrefs);
                }
            }
            catch (NumberFormatException nfe) {
                this.log.warn("unexpected Preference value for ACME_HTTP01_TIMEOUT_MILLI_SEC '{}'", (Object)nfe.getMessage());
                return ResponseEntity.badRequest().body((Object)oldPrefs);
            }
            if (portsCommaSeparatedList.trim().length() > 0) {
                portsCommaSeparatedList = portsCommaSeparatedList + ",";
            }
            portsCommaSeparatedList = portsCommaSeparatedList + nPort;
        }
        List upList = this.userPreferenceService.findAllForUserId(userId);
        HashMap<String, UserPreference> upMap = new HashMap<String, UserPreference>();
        for (UserPreference up : upList) {
            upMap.put(up.getName(), up);
        }
        this.updateValue(upMap, "CheckCRL", "" + preferences.isCheckCRL(), userId);
        this.updateValue(upMap, "ServerSideKeyCreationAllowed", "" + preferences.isServerSideKeyCreationAllowed(), userId);
        this.updateValue(upMap, "AcmeHTTP01CallbackPorts", portsCommaSeparatedList, userId);
        this.updateValue(upMap, "AcmeHTTP01TimeoutMilliSec", "" + preferences.getAcmeHTTP01TimeoutMilliSec(), userId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)userId.toString()))).body((Object)preferences);
    }

    private void updateValue(Map<String, UserPreference> upMap, String key, String value, Long userId) {
        if (upMap.containsKey(key)) {
            UserPreference up = upMap.get(key);
            if (!value.equalsIgnoreCase(up.getContent().trim())) {
                this.log.debug("New preferences value '{}' != current value '{}'", (Object)value, (Object)up.getContent().trim());
                up.setContent(value);
                this.userPreferenceService.save(up);
            }
        } else {
            this.log.debug("Ceating new preferences for key '{}' and value '{}'", (Object)key, (Object)value);
            UserPreference up = new UserPreference();
            up.setUserId(userId);
            up.setName(key);
            up.setContent(value);
            this.userPreferenceService.save(up);
        }
    }
}

