/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.CAConnectorConfigService;
import de.trustable.ca3s.core.service.dto.CAConnectorStatus;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class CAConnectorConfigResource {
    public static final String PLAIN_SECRET_PLACEHOLDER = "******";
    private final Logger log = LoggerFactory.getLogger(CAConnectorConfigResource.class);
    private static final String ENTITY_NAME = "cAConnectorConfig";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private ProtectedContentUtil protUtil;
    private ProtectedContentRepository protContentRepository;
    private CAConnectorConfigRepository caConfigRepository;
    private CaConnectorAdapter caConnectorAdapter;
    private final CAConnectorConfigService cAConnectorConfigService;

    public CAConnectorConfigResource(CAConnectorConfigService cAConnectorConfigService, ProtectedContentUtil protUtil, ProtectedContentRepository protContentRepository, CAConnectorConfigRepository caConfigRepository, CaConnectorAdapter caConnectorAdapter) {
        this.protUtil = protUtil;
        this.protContentRepository = protContentRepository;
        this.caConfigRepository = caConfigRepository;
        this.cAConnectorConfigService = cAConnectorConfigService;
        this.caConnectorAdapter = caConnectorAdapter;
    }

    @PostMapping(value={"/ca-connector-configs"})
    public ResponseEntity<CAConnectorConfig> createCAConnectorConfig(@Valid @RequestBody CAConnectorConfig cAConnectorConfig) throws URISyntaxException {
        this.log.debug("REST request to save CAConnectorConfig : {}", (Object)cAConnectorConfig);
        if (cAConnectorConfig.getId() != null) {
            throw new BadRequestAlertException("A new cAConnectorConfig cannot already have an ID", ENTITY_NAME, "idexists");
        }
        if (cAConnectorConfig.getPlainSecret() == null || cAConnectorConfig.getPlainSecret().trim().length() == 0) {
            this.log.debug("REST request to save CAConnectorConfig : cAConnectorConfig.getPlainSecret() == null");
            cAConnectorConfig.setSecret(null);
            cAConnectorConfig.setPlainSecret("");
        } else {
            if (this.protUtil == null) {
                System.err.println("Autowired 'protUtil' failed ...");
            }
            ProtectedContent protSecret = this.protUtil.createProtectedContent(cAConnectorConfig.getPlainSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, -1L);
            this.protContentRepository.save((Object)protSecret);
            cAConnectorConfig.setSecret(protSecret);
            cAConnectorConfig.setPlainSecret(PLAIN_SECRET_PLACEHOLDER);
        }
        CAConnectorConfig result = this.cAConnectorConfigService.save(cAConnectorConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/ca-connector-configs/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @Transactional
    @PutMapping(value={"/ca-connector-configs"})
    public ResponseEntity<CAConnectorConfig> updateCAConnectorConfig(@Valid @RequestBody CAConnectorConfig cAConnectorConfig) throws URISyntaxException {
        this.log.debug("REST request to update CAConnectorConfig : {}", (Object)cAConnectorConfig);
        if (cAConnectorConfig.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (cAConnectorConfig.getPlainSecret() == null || cAConnectorConfig.getPlainSecret().trim().length() == 0) {
            this.log.debug("REST request to update CAConnectorConfig : cAConnectorConfig.getPlainSecret() == null");
            if (cAConnectorConfig.getSecret() != null) {
                this.log.debug("REST request to update CAConnectorConfig : protContentRepository.delete() ");
                this.protContentRepository.delete((Object)cAConnectorConfig.getSecret());
            }
            cAConnectorConfig.setSecret(null);
            cAConnectorConfig.setPlainSecret("");
        } else if (PLAIN_SECRET_PLACEHOLDER.equals(cAConnectorConfig.getPlainSecret().trim())) {
            this.log.debug("REST request to update CAConnectorConfig : PLAIN_SECRET_PLACEHOLDER.equals(cAConnectorConfig.getPlainSecret())");
            cAConnectorConfig.setSecret(((CAConnectorConfig)this.caConfigRepository.getOne((Object)cAConnectorConfig.getId())).getSecret());
        } else {
            this.log.debug("REST request to update CAConnectorConfig : PlainSecret modified");
            if (cAConnectorConfig.getSecret() != null) {
                this.log.debug("REST request to update CAConnectorConfig : protContentRepository.delete() ");
                this.protContentRepository.delete((Object)cAConnectorConfig.getSecret());
            }
            if (this.protUtil == null) {
                System.err.println("Autowired 'protUtil' failed ...");
            }
            ProtectedContent protSecret = this.protUtil.createProtectedContent(cAConnectorConfig.getPlainSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, cAConnectorConfig.getId().longValue());
            this.protContentRepository.save((Object)protSecret);
            cAConnectorConfig.setSecret(protSecret);
            cAConnectorConfig.setPlainSecret(PLAIN_SECRET_PLACEHOLDER);
        }
        if (cAConnectorConfig.isDefaultCA().booleanValue()) {
            for (CAConnectorConfig other : this.caConfigRepository.findAll()) {
                if (other.getId() == cAConnectorConfig.getId() || !other.isDefaultCA().booleanValue()) continue;
                this.log.debug("REST request to update CAConnectorConfig : remove 'deaultCA' flag from caConfig {} ", (Object)other.getId());
                other.setDefaultCA(Boolean.valueOf(false));
                this.caConfigRepository.save((Object)other);
            }
        }
        CAConnectorConfig result = this.cAConnectorConfigService.save(cAConnectorConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)cAConnectorConfig.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/ca-connector-configs/status"})
    @PreAuthorize(value="isAuthenticated()")
    public List<CAConnectorStatus> getCAConnectorStatus() {
        return this.caConnectorAdapter.getCAConnectorStatus();
    }

    @GetMapping(value={"/ca-connector-configs"})
    public List<CAConnectorConfig> getAllCAConnectorConfigs() {
        this.log.debug("REST request to get all CAConnectorConfigs");
        return this.cAConnectorConfigService.findAll();
    }

    @GetMapping(value={"/ca-connector-configs/{id}"})
    public ResponseEntity<CAConnectorConfig> getCAConnectorConfig(@PathVariable Long id) {
        this.log.debug("REST request to get CAConnectorConfig : {}", (Object)id);
        Optional cAConnectorConfig = this.cAConnectorConfigService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)cAConnectorConfig);
    }

    @DeleteMapping(value={"/ca-connector-configs/{id}"})
    public ResponseEntity<Void> deleteCAConnectorConfig(@PathVariable Long id) {
        this.log.debug("REST request to delete CAConnectorConfig : {}", (Object)id);
        this.cAConnectorConfigService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

