/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.repository.PipelineAttributeRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.PipelineService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PipelineServiceImpl
implements PipelineService {
    private final Logger log = LoggerFactory.getLogger(PipelineServiceImpl.class);
    private final PipelineRepository pipelineRepository;
    @Autowired
    private PipelineAttributeRepository pipelineAttributeRepository;
    @Autowired
    private AuditService auditService;

    public PipelineServiceImpl(PipelineRepository pipelineRepository) {
        this.pipelineRepository = pipelineRepository;
    }

    public Pipeline save(Pipeline pipeline) {
        this.log.debug("Request to save Pipeline : {}", (Object)pipeline);
        return (Pipeline)this.pipelineRepository.save((Object)pipeline);
    }

    @Transactional(readOnly=true)
    public List<Pipeline> findAll() {
        this.log.debug("Request to get all Pipelines");
        return this.pipelineRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<Pipeline> findOne(Long id) {
        this.log.debug("Request to get Pipeline : {}", (Object)id);
        return this.pipelineRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Pipeline : {}", (Object)id);
        Optional pipelineOpt = this.pipelineRepository.findById((Object)id);
        if (pipelineOpt.isPresent()) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTracePipeline("PIPELINE_DELETED", null));
            this.pipelineAttributeRepository.deleteAll((Iterable)((Pipeline)pipelineOpt.get()).getPipelineAttributes());
            this.pipelineRepository.deleteById((Object)id);
        }
    }
}

