/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.service.AuditTraceService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuditTraceServiceImpl
implements AuditTraceService {
    private final Logger log = LoggerFactory.getLogger(AuditTraceServiceImpl.class);
    private final AuditTraceRepository auditTraceRepository;

    public AuditTraceServiceImpl(AuditTraceRepository auditTraceRepository) {
        this.auditTraceRepository = auditTraceRepository;
    }

    public AuditTrace save(AuditTrace auditTrace) {
        this.log.debug("Request to save AuditTrace : {}", (Object)auditTrace);
        return (AuditTrace)this.auditTraceRepository.save((Object)auditTrace);
    }

    @Transactional(readOnly=true)
    public List<AuditTrace> findAll() {
        this.log.debug("Request to get all AuditTraces");
        return this.auditTraceRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<AuditTrace> findOne(Long id) {
        this.log.debug("Request to get AuditTrace : {}", (Object)id);
        return this.auditTraceRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AuditTrace : {}", (Object)id);
        this.auditTraceRepository.deleteById((Object)id);
    }
}

