/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CertificateAttribute;
import de.trustable.ca3s.core.service.dto.AuditView;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger LOG = LoggerFactory.getLogger(CertificateView.class);
    private Long id;
    private Long csrId;
    private Long issuerId;
    private String tbsDigest;
    private String subject;
    private String sans;
    private String issuer;
    private String root;
    private String fingerprint;
    private String type;
    private String keyLength;
    private String keyAlgorithm;
    private String signingAlgorithm;
    private String paddingAlgorithm;
    private String hashAlgorithm;
    private String description;
    private String serial;
    private Instant validFrom;
    private Instant validTo;
    private Instant contentAddedAt;
    private Instant revokedSince;
    private String revocationReason;
    private Boolean revoked;
    private Boolean selfsigned;
    private Boolean ca;
    private Boolean intermediate;
    private Boolean endEntity;
    private Long chainLength;
    private String[] usage;
    private String[] extUsage;
    private String[] sanArr;
    private Long caConnectorId;
    private Long caProcessingId;
    private String processingCa;
    private Long acmeAccountId;
    private Long acmeOrderId;
    private Long scepTransId;
    private String scepRecipient;
    private String fileSource;
    private String uploadedBy;
    private String revokedBy;
    private String requestedBy;
    private String crlUrl;
    private Instant crlNextUpdate;
    private String certB64;
    private String downloadFilename;
    private Boolean isServersideKeyGeneration = false;
    private AuditView[] auditViewArr;

    public CertificateView() {
    }

    public CertificateView(Certificate cert) {
        this.id = cert.getId();
        this.tbsDigest = cert.getTbsDigest();
        this.subject = cert.getSubject();
        this.sans = cert.getSans();
        this.issuer = cert.getIssuer();
        this.type = cert.getType();
        this.fingerprint = cert.getFingerprint();
        this.keyLength = cert.getKeyLength().toString();
        this.keyAlgorithm = cert.getKeyAlgorithm();
        this.signingAlgorithm = cert.getSigningAlgorithm();
        this.paddingAlgorithm = cert.getPaddingAlgorithm();
        this.hashAlgorithm = cert.getHashingAlgorithm();
        this.description = cert.getDescription();
        this.serial = cert.getSerial();
        this.validFrom = cert.getValidFrom();
        this.validTo = cert.getValidTo();
        this.contentAddedAt = cert.getContentAddedAt();
        this.revokedSince = cert.getRevokedSince();
        this.revocationReason = cert.getRevocationReason();
        this.revoked = cert.isRevoked();
        this.certB64 = cert.getContent();
        if (cert.getCsr() != null) {
            this.requestedBy = cert.getCsr().getRequestedBy();
            this.csrId = cert.getCsr().getId();
            this.isServersideKeyGeneration = cert.getCsr().isServersideKeyGeneration();
        } else {
            this.requestedBy = "";
        }
        if (cert.getIssuingCertificate() != null) {
            this.issuerId = cert.getIssuingCertificate().getId();
        }
        ArrayList<String> usageList = new ArrayList<String>();
        ArrayList<String> extUsageList = new ArrayList<String>();
        for (CertificateAttribute certAttr : cert.getCertificateAttributes()) {
            if ("CA_CONNECTOR_ID".equalsIgnoreCase(certAttr.getName())) {
                this.caConnectorId = Long.parseLong(certAttr.getValue());
                continue;
            }
            if ("CA_PROCESSING_ID".equalsIgnoreCase(certAttr.getName())) {
                this.caProcessingId = Long.parseLong(certAttr.getValue());
                continue;
            }
            if ("PROCESSING_CA".equalsIgnoreCase(certAttr.getName())) {
                this.processingCa = certAttr.getValue();
                continue;
            }
            if ("SOURCE".equalsIgnoreCase(certAttr.getName())) {
                this.fileSource = certAttr.getValue();
                continue;
            }
            if ("UPLOADED_BY".equalsIgnoreCase(certAttr.getName())) {
                this.uploadedBy = certAttr.getValue();
                continue;
            }
            if ("REVOKED_BY".equalsIgnoreCase(certAttr.getName())) {
                this.revokedBy = certAttr.getValue();
                continue;
            }
            if ("CRL_URL".equalsIgnoreCase(certAttr.getName())) {
                this.crlUrl = certAttr.getValue();
                continue;
            }
            if ("CRL_NEXT_UPDATE".equalsIgnoreCase(certAttr.getName())) {
                this.crlNextUpdate = Instant.ofEpochMilli(Long.parseLong(certAttr.getValue()));
                continue;
            }
            if ("ACME:ACCOUNT_ID".equalsIgnoreCase(certAttr.getName())) {
                this.acmeAccountId = Long.parseLong(certAttr.getValue());
                continue;
            }
            if ("ACME:ORDER_ID".equalsIgnoreCase(certAttr.getName())) {
                this.acmeOrderId = Long.parseLong(certAttr.getValue());
                continue;
            }
            if ("CA3S:SCEP_RECIPIENT".equalsIgnoreCase(certAttr.getName())) {
                this.scepRecipient = certAttr.getValue();
                continue;
            }
            if ("CA3S:SCEP_TRANS_ID".equalsIgnoreCase(certAttr.getName())) {
                this.scepTransId = Long.parseLong(certAttr.getValue());
                continue;
            }
            if ("CA3S:SELFSIGNED".equalsIgnoreCase(certAttr.getName())) {
                this.selfsigned = Boolean.valueOf(certAttr.getValue());
                continue;
            }
            if ("CA3S:CA".equalsIgnoreCase(certAttr.getName())) {
                this.ca = Boolean.valueOf(certAttr.getValue());
                continue;
            }
            if ("CA3S:ROOT".equalsIgnoreCase(certAttr.getName()) || "ROOT".equalsIgnoreCase(certAttr.getName()) || "CA3S:INTERMEDIATE".equalsIgnoreCase(certAttr.getName())) continue;
            if ("CA3S:END_ENTITY".equalsIgnoreCase(certAttr.getName())) {
                this.endEntity = Boolean.valueOf(certAttr.getValue());
                continue;
            }
            if ("CA3S:CHAIN_LENGTH".equalsIgnoreCase(certAttr.getName())) {
                this.chainLength = Long.parseLong(certAttr.getValue());
                continue;
            }
            if ("USAGE".equalsIgnoreCase(certAttr.getName())) {
                usageList.add(certAttr.getValue());
                continue;
            }
            if ("EXTENDED_USAGE".equalsIgnoreCase(certAttr.getName())) {
                extUsageList.add(certAttr.getValue());
                continue;
            }
            this.LOG.debug("Irrelevant certificate attribute '{}' with value '{}'", (Object)certAttr.getName(), (Object)certAttr.getValue());
        }
        this.usage = usageList.toArray(new String[usageList.size()]);
        this.extUsage = extUsageList.toArray(new String[extUsageList.size()]);
        this.downloadFilename = CertificateUtil.getDownloadFilename((Certificate)cert);
    }

    public Long getId() {
        return this.id;
    }

    public String getTbsDigest() {
        return this.tbsDigest;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSerial() {
        return this.serial;
    }

    public Instant getValidFrom() {
        return this.validFrom;
    }

    public Instant getValidTo() {
        return this.validTo;
    }

    public Instant getContentAddedAt() {
        return this.contentAddedAt;
    }

    public Instant getRevokedSince() {
        return this.revokedSince;
    }

    public String getRevocationReason() {
        return this.revocationReason;
    }

    public Boolean getRevoked() {
        return this.revoked;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTbsDigest(String tbsDigest) {
        this.tbsDigest = tbsDigest;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public void setValidFrom(Instant validFrom) {
        this.validFrom = validFrom;
    }

    public void setValidTo(Instant validTo) {
        this.validTo = validTo;
    }

    public void setContentAddedAt(Instant contentAddedAt) {
        this.contentAddedAt = contentAddedAt;
    }

    public void setRevokedSince(Instant revokedSince) {
        this.revokedSince = revokedSince;
    }

    public void setRevocationReason(String revocationReason) {
        this.revocationReason = revocationReason;
    }

    public void setRevoked(Boolean revoked) {
        this.revoked = revoked;
    }

    public String getKeyLength() {
        return this.keyLength;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public String getPaddingAlgorithm() {
        return this.paddingAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setKeyLength(String keyLength) {
        this.keyLength = keyLength;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public void setPaddingAlgorithm(String paddingAlgorithm) {
        this.paddingAlgorithm = paddingAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getSans() {
        return this.sans;
    }

    public void setSans(String sans) {
        this.sans = sans;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public Boolean getSelfsigned() {
        return this.selfsigned;
    }

    public Boolean getCa() {
        return this.ca;
    }

    public String getRoot() {
        return this.root;
    }

    public Boolean getIntermediate() {
        return this.intermediate;
    }

    public Boolean getEndEntity() {
        return this.endEntity;
    }

    public Long getChainLength() {
        return this.chainLength;
    }

    public String[] getUsage() {
        return this.usage;
    }

    public String[] getSanArr() {
        return this.sanArr;
    }

    public Long getCaConnectorId() {
        return this.caConnectorId;
    }

    public Long getCaProcessingId() {
        return this.caProcessingId;
    }

    public String getFileSource() {
        return this.fileSource;
    }

    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public String getRevokedBy() {
        return this.revokedBy;
    }

    public String getCrlUrl() {
        return this.crlUrl;
    }

    public Instant getCrlNextUpdate() {
        return this.crlNextUpdate;
    }

    public void setSelfsigned(Boolean selfsigned) {
        this.selfsigned = selfsigned;
    }

    public void setCa(Boolean ca) {
        this.ca = ca;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setIntermediate(Boolean intermediate) {
        this.intermediate = intermediate;
    }

    public void setEndEntity(Boolean endEntity) {
        this.endEntity = endEntity;
    }

    public void setChainLength(Long chainLength) {
        this.chainLength = chainLength;
    }

    public void setUsage(String[] usage) {
        this.usage = usage;
    }

    public void setSanArr(String[] sanArr) {
        this.sanArr = sanArr;
    }

    public void setCaConnectorId(Long caConnectorId) {
        this.caConnectorId = caConnectorId;
    }

    public void setCaProcessingId(Long caProcessingId) {
        this.caProcessingId = caProcessingId;
    }

    public void setFileSource(String fileSource) {
        this.fileSource = fileSource;
    }

    public void setUploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    public void setRevokedBy(String revokedBy) {
        this.revokedBy = revokedBy;
    }

    public void setCrlUrl(String crlUrl) {
        this.crlUrl = crlUrl;
    }

    public void setCrlNextUpdate(Instant crlNextUpdate) {
        this.crlNextUpdate = crlNextUpdate;
    }

    public Long getAcmeAccountId() {
        return this.acmeAccountId;
    }

    public Long getAcmeOrderId() {
        return this.acmeOrderId;
    }

    public Long getScepTransId() {
        return this.scepTransId;
    }

    public String getScepRecipient() {
        return this.scepRecipient;
    }

    public void setAcmeAccountId(Long acmeAccountId) {
        this.acmeAccountId = acmeAccountId;
    }

    public void setAcmeOrderId(Long acmeOrderId) {
        this.acmeOrderId = acmeOrderId;
    }

    public void setScepTransId(Long scepTransId) {
        this.scepTransId = scepTransId;
    }

    public void setScepRecipient(String scepRecipient) {
        this.scepRecipient = scepRecipient;
    }

    public String[] getExtUsage() {
        return this.extUsage;
    }

    public void setExtUsage(String[] extUsage) {
        this.extUsage = extUsage;
    }

    public String getRequestedBy() {
        return this.requestedBy;
    }

    public void setRequestedBy(String requestedBy) {
        this.requestedBy = requestedBy;
    }

    public String getDownloadFilename() {
        return this.downloadFilename;
    }

    public void setDownloadFilename(String downloadFilename) {
        this.downloadFilename = downloadFilename;
    }

    public Long getCsrId() {
        return this.csrId;
    }

    public Long getIssuerId() {
        return this.issuerId;
    }

    public void setCsrId(Long csrId) {
        this.csrId = csrId;
    }

    public void setIssuerId(Long issuerId) {
        this.issuerId = issuerId;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getProcessingCa() {
        return this.processingCa;
    }

    public void setProcessingCa(String processingCa) {
        this.processingCa = processingCa;
    }

    public String getCertB64() {
        return this.certB64;
    }

    public void setCertB64(String certB64) {
        this.certB64 = certB64;
    }

    public Boolean getIsServersideKeyGeneration() {
        return this.isServersideKeyGeneration;
    }

    public void setIsServersideKeyGeneration(Boolean isServersideKeyGeneration) {
        this.isServersideKeyGeneration = isServersideKeyGeneration;
    }

    public AuditView[] getAuditViewArr() {
        return this.auditViewArr;
    }

    public void setAuditViewArr(AuditView[] auditViewArr) {
        this.auditViewArr = auditViewArr;
    }
}

