/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.RDN;
import de.trustable.ca3s.core.domain.RequestAttribute;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="csr")
@NamedQueries(value={@NamedQuery(name="CSR.findByPublicKeyHash", query="SELECT c FROM CSR c WHERE c.publicKeyHash = :hash"), @NamedQuery(name="CSR.countAll", query="SELECT count(c) FROM CSR c "), @NamedQuery(name="CSR.findPendingByDay", query="SELECT c FROM CSR c WHERE  c.requestedOn >= :after and  c.requestedOn <= :before and  c.status = 'PENDING' "), @NamedQuery(name="CSR.findPendingGroupedByDay", query="SELECT concat(YEAR(c.requestedOn), '.', MONTH(c.requestedOn), '.', DAY(c.requestedOn)), count(c) FROM CSR c WHERE  c.requestedOn >= :after and  c.requestedOn <= :before and  c.status = 'PENDING'  group by YEAR(c.requestedOn), MONTH(c.requestedOn), DAY(c.requestedOn)")})
public class CSR
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Lob
    @Column(name="csr_base_64", nullable=false)
    private String csrBase64;
    @NotNull
    @Column(name="subject", nullable=false)
    private String subject;
    @Column(name="sans")
    private String sans;
    @NotNull
    @Column(name="requested_on", nullable=false)
    private Instant requestedOn;
    @NotNull
    @Column(name="requested_by", nullable=false)
    private String requestedBy;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="pipeline_type", nullable=false)
    private PipelineType pipelineType;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    private CsrStatus status;
    @Column(name="administered_by")
    private String administeredBy;
    @Column(name="approved_on")
    private Instant approvedOn;
    @Column(name="rejected_on")
    private Instant rejectedOn;
    @Column(name="rejection_reason")
    private String rejectionReason;
    @Column(name="process_instance_id")
    private String processInstanceId;
    @Column(name="signing_algorithm")
    private String signingAlgorithm;
    @Column(name="is_csr_valid")
    private Boolean isCSRValid;
    @Column(name="x_509_key_spec")
    private String x509KeySpec;
    @Column(name="public_key_algorithm")
    private String publicKeyAlgorithm;
    @Column(name="key_algorithm")
    private String keyAlgorithm;
    @Column(name="key_length")
    private Integer keyLength;
    @Column(name="public_key_hash")
    private String publicKeyHash;
    @Column(name="serverside_key_generation")
    private Boolean serversideKeyGeneration;
    @Lob
    @Column(name="subject_public_key_info_base_64", nullable=false)
    private String subjectPublicKeyInfoBase64;
    @Lob
    @Column(name="requestor_comment")
    private String requestorComment;
    @Lob
    @Column(name="administration_comment")
    private String administrationComment;
    @OneToMany(mappedBy="csr")
    private Set<RDN> rdns = new HashSet();
    @OneToMany(mappedBy="csr")
    private Set<RequestAttribute> ras = new HashSet();
    @OneToMany(fetch=FetchType.EAGER, mappedBy="csr", cascade={CascadeType.ALL})
    @JsonIgnoreProperties(value={"csr"})
    private Set<CsrAttribute> csrAttributes = new HashSet();
    @ManyToOne
    @JsonIgnoreProperties(value={"cSRS"})
    private Pipeline pipeline;
    @OneToOne(mappedBy="csr")
    @JsonIgnore
    private Certificate certificate;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCsrBase64() {
        return this.csrBase64;
    }

    public CSR csrBase64(String csrBase64) {
        this.csrBase64 = csrBase64;
        return this;
    }

    public void setCsrBase64(String csrBase64) {
        this.csrBase64 = csrBase64;
    }

    public String getSubject() {
        return this.subject;
    }

    public CSR subject(String subject) {
        this.subject = subject;
        return this;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSans() {
        return this.sans;
    }

    public CSR sans(String sans) {
        this.sans = sans;
        return this;
    }

    public void setSans(String sans) {
        this.sans = sans;
    }

    public Instant getRequestedOn() {
        return this.requestedOn;
    }

    public CSR requestedOn(Instant requestedOn) {
        this.requestedOn = requestedOn;
        return this;
    }

    public void setRequestedOn(Instant requestedOn) {
        this.requestedOn = requestedOn;
    }

    public String getRequestedBy() {
        return this.requestedBy;
    }

    public CSR requestedBy(String requestedBy) {
        this.requestedBy = requestedBy;
        return this;
    }

    public void setRequestedBy(String requestedBy) {
        this.requestedBy = requestedBy;
    }

    public PipelineType getPipelineType() {
        return this.pipelineType;
    }

    public CSR pipelineType(PipelineType pipelineType) {
        this.pipelineType = pipelineType;
        return this;
    }

    public void setPipelineType(PipelineType pipelineType) {
        this.pipelineType = pipelineType;
    }

    public CsrStatus getStatus() {
        return this.status;
    }

    public CSR status(CsrStatus status) {
        this.status = status;
        return this;
    }

    public void setStatus(CsrStatus status) {
        this.status = status;
    }

    public String getAdministeredBy() {
        return this.administeredBy;
    }

    public CSR administeredBy(String administeredBy) {
        this.administeredBy = administeredBy;
        return this;
    }

    public void setAdministeredBy(String administeredBy) {
        this.administeredBy = administeredBy;
    }

    public Instant getApprovedOn() {
        return this.approvedOn;
    }

    public CSR approvedOn(Instant approvedOn) {
        this.approvedOn = approvedOn;
        return this;
    }

    public void setApprovedOn(Instant approvedOn) {
        this.approvedOn = approvedOn;
    }

    public Instant getRejectedOn() {
        return this.rejectedOn;
    }

    public CSR rejectedOn(Instant rejectedOn) {
        this.rejectedOn = rejectedOn;
        return this;
    }

    public void setRejectedOn(Instant rejectedOn) {
        this.rejectedOn = rejectedOn;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public CSR rejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
        return this;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public CSR processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public CSR signingAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public Boolean isIsCSRValid() {
        return this.isCSRValid;
    }

    public CSR isCSRValid(Boolean isCSRValid) {
        this.isCSRValid = isCSRValid;
        return this;
    }

    public void setIsCSRValid(Boolean isCSRValid) {
        this.isCSRValid = isCSRValid;
    }

    public String getx509KeySpec() {
        return this.x509KeySpec;
    }

    public CSR x509KeySpec(String x509KeySpec) {
        this.x509KeySpec = x509KeySpec;
        return this;
    }

    public void setx509KeySpec(String x509KeySpec) {
        this.x509KeySpec = x509KeySpec;
    }

    public String getPublicKeyAlgorithm() {
        return this.publicKeyAlgorithm;
    }

    public CSR publicKeyAlgorithm(String publicKeyAlgorithm) {
        this.publicKeyAlgorithm = publicKeyAlgorithm;
        return this;
    }

    public void setPublicKeyAlgorithm(String publicKeyAlgorithm) {
        this.publicKeyAlgorithm = publicKeyAlgorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public CSR keyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return this;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public Integer getKeyLength() {
        return this.keyLength;
    }

    public CSR keyLength(Integer keyLength) {
        this.keyLength = keyLength;
        return this;
    }

    public void setKeyLength(Integer keyLength) {
        this.keyLength = keyLength;
    }

    public String getPublicKeyHash() {
        return this.publicKeyHash;
    }

    public CSR publicKeyHash(String publicKeyHash) {
        this.publicKeyHash = publicKeyHash;
        return this;
    }

    public void setPublicKeyHash(String publicKeyHash) {
        this.publicKeyHash = publicKeyHash;
    }

    public Boolean isServersideKeyGeneration() {
        return this.serversideKeyGeneration;
    }

    public CSR serversideKeyGeneration(Boolean serversideKeyGeneration) {
        this.serversideKeyGeneration = serversideKeyGeneration;
        return this;
    }

    public void setServersideKeyGeneration(Boolean serversideKeyGeneration) {
        this.serversideKeyGeneration = serversideKeyGeneration;
    }

    public String getSubjectPublicKeyInfoBase64() {
        return this.subjectPublicKeyInfoBase64;
    }

    public CSR subjectPublicKeyInfoBase64(String subjectPublicKeyInfoBase64) {
        this.subjectPublicKeyInfoBase64 = subjectPublicKeyInfoBase64;
        return this;
    }

    public void setSubjectPublicKeyInfoBase64(String subjectPublicKeyInfoBase64) {
        this.subjectPublicKeyInfoBase64 = subjectPublicKeyInfoBase64;
    }

    public String getRequestorComment() {
        return this.requestorComment;
    }

    public CSR requestorComment(String requestorComment) {
        this.requestorComment = requestorComment;
        return this;
    }

    public void setRequestorComment(String requestorComment) {
        this.requestorComment = requestorComment;
    }

    public String getAdministrationComment() {
        return this.administrationComment;
    }

    public CSR administrationComment(String administrationComment) {
        this.administrationComment = administrationComment;
        return this;
    }

    public void setAdministrationComment(String administrationComment) {
        this.administrationComment = administrationComment;
    }

    public Set<RDN> getRdns() {
        return this.rdns;
    }

    public CSR rdns(Set<RDN> rDNS) {
        this.rdns = rDNS;
        return this;
    }

    public CSR addRdns(RDN rDN) {
        this.rdns.add(rDN);
        rDN.setCsr(this);
        return this;
    }

    public CSR removeRdns(RDN rDN) {
        this.rdns.remove(rDN);
        rDN.setCsr(null);
        return this;
    }

    public void setRdns(Set<RDN> rDNS) {
        this.rdns = rDNS;
    }

    public Set<RequestAttribute> getRas() {
        return this.ras;
    }

    public CSR ras(Set<RequestAttribute> requestAttributes) {
        this.ras = requestAttributes;
        return this;
    }

    public CSR addRas(RequestAttribute requestAttribute) {
        this.ras.add(requestAttribute);
        requestAttribute.setCsr(this);
        return this;
    }

    public CSR removeRas(RequestAttribute requestAttribute) {
        this.ras.remove(requestAttribute);
        requestAttribute.setCsr(null);
        return this;
    }

    public void setRas(Set<RequestAttribute> requestAttributes) {
        this.ras = requestAttributes;
    }

    public Set<CsrAttribute> getCsrAttributes() {
        return this.csrAttributes;
    }

    public CSR csrAttributes(Set<CsrAttribute> csrAttributes) {
        this.csrAttributes = csrAttributes;
        return this;
    }

    public CSR addCsrAttributes(CsrAttribute csrAttribute) {
        this.csrAttributes.add(csrAttribute);
        csrAttribute.setCsr(this);
        return this;
    }

    public CSR removeCsrAttributes(CsrAttribute csrAttribute) {
        this.csrAttributes.remove(csrAttribute);
        csrAttribute.setCsr(null);
        return this;
    }

    public void setCsrAttributes(Set<CsrAttribute> csrAttributes) {
        this.csrAttributes = csrAttributes;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public CSR pipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public CSR certificate(Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CSR)) {
            return false;
        }
        return this.id != null && this.id.equals(((CSR)o).id);
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return "CSR{id=" + this.getId() + ", csrBase64='" + this.getCsrBase64() + "', subject='" + this.getSubject() + "', sans='" + this.getSans() + "', requestedOn='" + this.getRequestedOn() + "', requestedBy='" + this.getRequestedBy() + "', pipelineType='" + this.getPipelineType() + "', status='" + this.getStatus() + "', administeredBy='" + this.getAdministeredBy() + "', approvedOn='" + this.getApprovedOn() + "', rejectedOn='" + this.getRejectedOn() + "', rejectionReason='" + this.getRejectionReason() + "', processInstanceId='" + this.getProcessInstanceId() + "', signingAlgorithm='" + this.getSigningAlgorithm() + "', isCSRValid='" + this.isIsCSRValid() + "', x509KeySpec='" + this.getx509KeySpec() + "', publicKeyAlgorithm='" + this.getPublicKeyAlgorithm() + "', keyAlgorithm='" + this.getKeyAlgorithm() + "', keyLength=" + this.getKeyLength() + ", publicKeyHash='" + this.getPublicKeyHash() + "', serversideKeyGeneration='" + this.isServersideKeyGeneration() + "', subjectPublicKeyInfoBase64='" + this.getSubjectPublicKeyInfoBase64() + "', requestorComment='" + this.getRequestorComment() + "', administrationComment='" + this.getAdministrationComment() + "'}";
    }
}

