/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.web.rest.acme.ACMEController;
import de.trustable.ca3s.core.web.rest.support.NotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.HttpClientErrorException;

@Controller
@RequestMapping(value={"/publicapi"})
public class CertificateDownloadController {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateDownloadController.class);
    private boolean chainIncludeRoot = true;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private ProtectedContentUtil protContentUtil;

    @RequestMapping(value={"/certPKIX/{certId}/{filename}/{alias}"}, method={RequestMethod.GET}, produces={"application/pkix-cert"})
    @ResponseBody
    public byte[] getCertificatePKIX(@PathVariable long certId, @PathVariable String filename, @PathVariable String alias) throws NotFoundException {
        LOG.info("Received certificate download request (PKIX) for id {} as file '{}' and alias '{}'", new Object[]{certId, filename, alias});
        if (SecurityContextHolder.getContext() == null) {
            throw new NotFoundException("Authentication required");
        }
        try {
            return this.buildByteArrayResponseForId(certId, "application/pkix-cert", alias);
        }
        catch (AcmeProblemException | GeneralSecurityException | HttpClientErrorException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    @RequestMapping(value={"/certPEMChain/{certId}/{filename}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificatePEMChain(@PathVariable long certId, @PathVariable String filename) {
        LOG.info("Received certificate download request (PEM with chain) for id {} as file '{}'", (Object)certId, (Object)filename);
        return this.buildCertResponseForId(certId, "application/pem-certificate-chain");
    }

    @RequestMapping(value={"/certPEM/{certId}/{filename}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificatePEM(@PathVariable long certId, @PathVariable String filename) {
        LOG.info("Received certificate download request (PEM) for id {} as file '{}'", (Object)certId, (Object)filename);
        return this.buildCertResponseForId(certId, "application/pkix-cert");
    }

    @RequestMapping(value={"/cert/{certId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificate(@PathVariable long certId, @RequestHeader(name="Accept", defaultValue="application/pem-certificate-chain") String accept) {
        LOG.info("Received certificate request for id {}", (Object)certId);
        return this.buildCertResponseForId(certId, accept);
    }

    @RequestMapping(value={"/keystore/{certId}"}, method={RequestMethod.GET}, produces={"application/x-pkcs12"})
    @ResponseBody
    public byte[] getKeystore(@PathVariable long certId, @RequestHeader(name="Accept", defaultValue="application/x-pkcs12") String accept) throws NotFoundException {
        LOG.info("Received keystore request for id {}", (Object)certId);
        try {
            return this.buildByteArrayResponseForId(certId, accept, "");
        }
        catch (AcmeProblemException | GeneralSecurityException | HttpClientErrorException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    public ResponseEntity<?> buildCertResponseForId(long certId, String accept) throws HttpClientErrorException, AcmeProblemException {
        HttpHeaders headers;
        Optional certOpt = this.certificateRepository.findById((Object)certId);
        if (!certOpt.isPresent()) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
        Certificate certDao = (Certificate)certOpt.get();
        ResponseEntity resp = this.buildCertifcateResponse(accept, certDao, headers = new HttpHeaders());
        if (resp == null) {
            String msg = "problem returning certificate with accepting type " + accept;
            LOG.info(msg);
            return ResponseEntity.badRequest().build();
        }
        return resp;
    }

    @ResponseBody
    public byte[] buildByteArrayResponseForId(long certId, String accept, String alias) throws HttpClientErrorException, AcmeProblemException, GeneralSecurityException {
        Optional certOpt = this.certificateRepository.findById((Object)certId);
        if (!certOpt.isPresent()) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
        Certificate certDao = (Certificate)certOpt.get();
        HttpHeaders headers = new HttpHeaders();
        byte[] resp = null;
        if ("application/pkix-cert".equalsIgnoreCase(accept)) {
            resp = this.buildPkixCertResponse(certDao, headers);
        } else if ("application/x-pkcs12".equalsIgnoreCase(accept)) {
            resp = this.buildPKCS12Response(certDao, alias, headers);
        }
        if (resp == null) {
            String msg = "problem returning certificate with accepting type " + accept;
            LOG.info(msg);
            throw new GeneralSecurityException(msg);
        }
        return resp;
    }

    public ResponseEntity<?> buildCertifcateResponse(String accept, Certificate certDao, HttpHeaders headers) {
        if ("*/*".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers, true);
        }
        if ("application/pem-certificate-chain".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers, true);
        }
        if ("application/pem-certificate".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers, false);
        }
        LOG.info("unexpected accept type {}", (Object)accept);
        return null;
    }

    private ResponseEntity<?> buildPEMResponse(Certificate certDao, HttpHeaders headers, boolean includeChain) {
        LOG.info("building PEM certificate response");
        try {
            String resultPem = "";
            if (includeChain) {
                List chain = this.certUtil.getCertificateChain(certDao);
                Iterator it = chain.iterator();
                while (it.hasNext()) {
                    Certificate chainCertDao = (Certificate)it.next();
                    if (!it.hasNext() && !this.chainIncludeRoot) continue;
                    resultPem = resultPem + chainCertDao.getContent();
                }
            } else {
                resultPem = resultPem + certDao.getContent();
            }
            LOG.debug("returning cert and issuer : \n" + resultPem);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(ACMEController.APPLICATION_PEM_CERT_CHAIN).headers(headers)).body((Object)resultPem.getBytes());
        }
        catch (GeneralSecurityException ge) {
            String msg = "problem building certificate chain";
            LOG.info(msg, (Throwable)ge);
            return ResponseEntity.badRequest().build();
        }
    }

    @ResponseBody
    private byte[] buildPkixCertResponse(Certificate certDao, HttpHeaders headers) throws GeneralSecurityException {
        LOG.info("building PKIX certificate response");
        try {
            X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)certDao.getContent());
            return x509Cert.getEncoded();
        }
        catch (GeneralSecurityException gse) {
            LOG.info("problem downloading certificate content for cert id " + certDao.getId(), (Throwable)gse);
            throw gse;
        }
    }

    @ResponseBody
    private byte[] buildPKCS12Response(Certificate certDao, String alias, HttpHeaders headers) throws GeneralSecurityException {
        byte[] byArray;
        LOG.info("building PKCS12 container response");
        CSR csr = certDao.getCsr();
        if (csr == null) {
            throw new GeneralSecurityException("problem downloading keystore content for cert id " + certDao.getId() + ": no csr object available ");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        if (userName == null) {
            throw new GeneralSecurityException("problem downloading keystore content for csr id " + csr.getId() + ":  user name not available");
        }
        if (userName.equals(csr.getRequestedBy())) {
            throw new GeneralSecurityException("problem downloading keystore content for csr id " + csr.getId() + ": user does not match initial requestor");
        }
        if (!csr.isServersideKeyGeneration().booleanValue()) {
            throw new GeneralSecurityException("problem downloading keystore content for csr id " + csr.getId() + ": key not generated serverside");
        }
        List protContentList = this.protContentUtil.retrieveProtectedContent(ProtectedContentType.PASSWORD, ContentRelationType.CSR, csr.getId().longValue());
        if (protContentList.size() == 0) {
            throw new GeneralSecurityException("problem downloading keystore content for csr id " + csr.getId() + ": no keystore passphrase available ");
        }
        PrivateKey key = this.certUtil.getPrivateKey(ProtectedContentType.KEY, ContentRelationType.CSR, csr.getId());
        char[] passphraseChars = this.protContentUtil.unprotectString(((ProtectedContent)protContentList.get(0)).getContentBase64()).toCharArray();
        KeyStore p12 = KeyStore.getInstance("pkcs12");
        p12.load(null, passphraseChars);
        java.security.cert.Certificate[] chain = this.certUtil.getX509CertificateChain(certDao);
        p12.setKeyEntry("entry", key, passphraseChars, chain);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            p12.store(baos, passphraseChars);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            KeyStore store = KeyStore.getInstance("pkcs12");
            store.load(bais, passphraseChars);
            java.security.cert.Certificate cert = store.getCertificate(alias);
            LOG.debug("retrieved cert " + cert);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException gse) {
                throw new GeneralSecurityException("problem downloading keystore content for cert id " + certDao.getId());
            }
        }
        baos.close();
        return byArray;
    }
}

