/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.schedule.CertExpiryScheduler;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.web.rest.data.CertificateAdministrationData;
import de.trustable.util.CryptoUtil;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import javax.validation.Valid;
import org.bouncycastle.asn1.x509.CRLReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thymeleaf.context.Context;

@RestController
@RequestMapping(value={"/api"})
public class CertificateAdministration {
    private final Logger LOG = LoggerFactory.getLogger(CertificateAdministration.class);
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private BPMNUtil bpmnUtil;
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MailService mailService;
    @Autowired
    private CertExpiryScheduler certExpiryScheduler;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @PostMapping(value={"/administerCertificate"})
    @Transactional
    public ResponseEntity<Long> administerRequest(@Valid @RequestBody CertificateAdministrationData adminData) {
        this.LOG.debug("REST request to revoke certificate : {}", (Object)adminData);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String raOfficerName = auth.getName();
        Optional optCert = this.certificateRepository.findById((Object)adminData.getCertificateId());
        if (optCert.isPresent()) {
            Certificate cert = (Certificate)optCert.get();
            try {
                this.revokeCertificate(cert, adminData, raOfficerName);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(raOfficerName, "CERTIFICATE_REVOKED", new String[]{"certificate " + cert.getId() + " revoked by RA Officer  '" + raOfficerName + "'"}));
                CSR csr = cert.getCsr();
                if (csr != null) {
                    Optional optUser = this.userRepository.findOneByLogin(csr.getRequestedBy());
                    if (optUser.isPresent()) {
                        User requestor = (User)optUser.get();
                        if (requestor.getEmail() == null) {
                            this.LOG.debug("Email doesn't exist for user '{}'", (Object)requestor.getLogin());
                        } else {
                            Locale locale = Locale.forLanguageTag(requestor.getLangKey());
                            Context context = new Context(locale);
                            context.setVariable("csr", (Object)csr);
                            context.setVariable("cert", (Object)cert);
                            String subject = cert.getSubject();
                            if (subject == null) {
                                subject = "";
                            }
                            String[] args = new String[]{subject, cert.getSerial(), cert.getIssuer()};
                            this.mailService.sendEmailFromTemplate(context, requestor, "mail/revokedCertificateEmail", "email.revokedCertificate.title", args);
                        }
                    } else {
                        this.LOG.info("certificate requestor '{}' unknown!", (Object)csr.getRequestedBy());
                    }
                }
                return new ResponseEntity((Object)adminData.getCertificateId(), HttpStatus.OK);
            }
            catch (GeneralSecurityException e) {
                return ResponseEntity.badRequest().build();
            }
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/withdrawOwnCertificate"})
    @Transactional
    public ResponseEntity<Long> withdrawOwnCertificate(@Valid @RequestBody CertificateAdministrationData adminData) {
        this.LOG.debug("REST request to withdraw Certificate : {}", (Object)adminData);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        Optional optCert = this.certificateRepository.findById((Object)adminData.getCertificateId());
        if (optCert.isPresent()) {
            Certificate certificate = (Certificate)optCert.get();
            String requestedBy = certificate.getCsr().getRequestedBy();
            if (userName == null || requestedBy == null || !userName.equals(requestedBy)) {
                this.LOG.debug("REST request by '{}' to revoke certificate '{}' rejected ", (Object)userName, (Object)adminData.getCertificateId());
                return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
            }
            try {
                this.revokeCertificate(certificate, adminData, userName);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(userName, "CERTIFICATE_REVOKED", new String[]{"certificate " + certificate.getId() + " revoked by owner '" + userName + "'"}));
                return new ResponseEntity((Object)adminData.getCertificateId(), HttpStatus.OK);
            }
            catch (GeneralSecurityException e) {
                return ResponseEntity.badRequest().build();
            }
        }
        return ResponseEntity.notFound().build();
    }

    private void revokeCertificate(Certificate certDao, CertificateAdministrationData adminData, String revokingUser) throws GeneralSecurityException {
        if (certDao.isRevoked().booleanValue()) {
            this.LOG.warn("failureReason: certificate with id '" + certDao.getId() + "' already revoked.");
        }
        CRLReason crlReason = this.cryptoUtil.crlReasonFromString(adminData.getRevocationReason());
        String crlReasonStr = this.cryptoUtil.crlReasonAsString(crlReason);
        this.LOG.debug("crlReason : " + crlReasonStr + " from " + adminData.getRevocationReason());
        Date revocationDate = new Date();
        this.bpmnUtil.startCertificateRevoctionProcess(certDao, crlReason, revocationDate);
        certDao.setActive(Boolean.valueOf(false));
        certDao.setRevoked(Boolean.valueOf(true));
        certDao.setRevokedSince(Instant.now());
        certDao.setRevocationReason(crlReasonStr);
        if (adminData.getComment() != null && adminData.getComment().trim().length() > 0) {
            certDao.setAdministrationComment(adminData.getComment());
        }
        this.certUtil.setCertAttribute(certDao, "REVOKED_BY", revokingUser);
        certDao.setRevocationExecutionId("39");
        this.certificateRepository.save((Object)certDao);
    }

    @PostMapping(value={"/sendExpiringCertificateEmail"})
    @Transactional
    public ResponseEntity<Integer> sendExpiringCertificateEmail() {
        int nExpiringCerts = this.certExpiryScheduler.notifyRAOfficerHolderOnExpiry();
        return new ResponseEntity((Object)nExpiringCerts, HttpStatus.OK);
    }
}

