/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.web.rest.data.AdministrationType;
import de.trustable.ca3s.core.web.rest.data.CSRAdministrationData;
import java.time.Instant;
import java.util.Locale;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thymeleaf.context.Context;

@RestController
@RequestMapping(value={"/api"})
public class CSRAdministration {
    private final Logger LOG = LoggerFactory.getLogger(CSRAdministration.class);
    @Autowired
    private CSRRepository csrRepository;
    @Autowired
    private BPMNUtil bpmnUtil;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MailService mailService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @PostMapping(value={"/administerRequest"})
    @Transactional
    public ResponseEntity<Long> administerRequest(@Valid @RequestBody CSRAdministrationData adminData) {
        this.LOG.debug("REST request to reject / accept CSR : {}", (Object)adminData);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String raOfficerName = auth.getName();
        Optional optCSR = this.csrRepository.findById((Object)adminData.getCsrId());
        if (optCSR.isPresent()) {
            CSR csr = (CSR)optCSR.get();
            csr.setAdministeredBy(raOfficerName);
            if (adminData.getComment() != null && !adminData.getComment().trim().isEmpty()) {
                csr.setAdministrationComment(adminData.getComment());
            }
            if (AdministrationType.ACCEPT.equals((Object)adminData.getAdministrationType())) {
                csr.setApprovedOn(Instant.now());
                this.csrRepository.save((Object)csr);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(raOfficerName, "CSR_ACCEPTED", new String[]{"csr " + csr.getId() + " accepted by RA Officer"}));
                Certificate cert = this.bpmnUtil.startCertificateCreationProcess(csr);
                if (cert != null) {
                    Optional optUser = this.userRepository.findOneByLogin(csr.getRequestedBy());
                    if (optUser.isPresent()) {
                        User requestor = (User)optUser.get();
                        if (requestor.getEmail() == null) {
                            this.LOG.debug("Email doesn't exist for user '{}'", (Object)requestor.getLogin());
                        } else {
                            Locale locale = Locale.forLanguageTag(requestor.getLangKey());
                            Context context = new Context(locale);
                            context.setVariable("certId", (Object)cert.getId());
                            context.setVariable("subject", (Object)cert.getSubject());
                            this.mailService.sendEmailFromTemplate(context, requestor, "mail/acceptedRequestEmail", "email.acceptedRequest.title");
                        }
                    } else {
                        this.LOG.warn("certificate requestor '{}' unknown!", (Object)csr.getRequestedBy());
                    }
                    return new ResponseEntity((Object)cert.getId(), HttpStatus.CREATED);
                }
                this.LOG.warn("creation of certificate requested for CSR {} failed ", (Object)csr.getId());
                return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.BAD_REQUEST);
            }
            csr.setRejectionReason(adminData.getRejectionReason());
            csr.setRejectedOn(Instant.now());
            csr.setStatus(CsrStatus.REJECTED);
            this.csrRepository.save((Object)csr);
            Optional optUser = this.userRepository.findOneByLogin(csr.getRequestedBy());
            if (optUser.isPresent()) {
                User requestor = (User)optUser.get();
                if (requestor.getEmail() == null) {
                    this.LOG.debug("Email doesn't exist for user '{}'", (Object)requestor.getLogin());
                } else {
                    Locale locale = Locale.forLanguageTag(requestor.getLangKey());
                    Context context = new Context(locale);
                    context.setVariable("csr", (Object)csr);
                    this.mailService.sendEmailFromTemplate(context, requestor, "mail/rejectedRequestEmail", "email.rejectedRequest.title");
                }
            } else {
                this.LOG.warn("certificate requestor '{}' unknown!", (Object)csr.getRequestedBy());
            }
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(raOfficerName, "CSR_REJECTED", new String[]{"csr " + csr.getId() + " rejected by RA Officer"}));
            return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/withdrawOwnRequest"})
    @Transactional
    public ResponseEntity<Long> withdrawOwnRequest(@Valid @RequestBody CSRAdministrationData adminData) {
        this.LOG.debug("REST request to withdraw CSR : {}", (Object)adminData);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        Optional optCSR = this.csrRepository.findById((Object)adminData.getCsrId());
        if (optCSR.isPresent()) {
            CSR csr = (CSR)optCSR.get();
            if (userName == null || !userName.equals(csr.getRequestedBy())) {
                this.LOG.debug("REST request by '{}' to withdraw CSR '{}' rejected ", (Object)userName, (Object)adminData.getCsrId());
                return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
            }
            csr.setAdministeredBy(userName);
            if (adminData.getComment() != null && !adminData.getComment().trim().isEmpty()) {
                csr.setAdministrationComment(adminData.getComment());
            }
            csr.setRejectionReason(adminData.getRejectionReason());
            csr.setRejectedOn(Instant.now());
            csr.setStatus(CsrStatus.REJECTED);
            this.csrRepository.save((Object)csr);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(userName, "CSR_REJECTED", new String[]{"csr " + csr.getId() + " withdrawn by user"}));
            return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }
}

