/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeChallengeRepository;
import de.trustable.ca3s.core.service.dto.acme.ChallengeResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.ACMEUtil;
import de.trustable.ca3s.core.web.rest.acme.ACMEController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Optional;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/acme/{realm}/challenge"})
public class ChallengeController
extends ACMEController {
    private static final Logger LOG = LoggerFactory.getLogger(ChallengeController.class);
    @Autowired
    private AcmeChallengeRepository challengeRepository;

    @RequestMapping(value={"/{challengeId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> getChallenge(@PathVariable long challengeId) {
        LOG.debug("Received Challenge request ");
        HttpHeaders additionalHeaders = this.buildNonceHeader();
        Optional challengeOpt = this.challengeRepository.findById((Object)challengeId);
        if (!challengeOpt.isPresent()) {
            return ResponseEntity.notFound().headers(additionalHeaders).build();
        }
        AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
        LOG.debug("returning challenge {}", (Object)challengeDao.getId());
        ChallengeResponse challenge = this.buildChallengeResponse(challengeDao);
        if (challengeDao.getStatus() == ChallengeStatus.VALID) {
            URI authUri = this.locationUriOfAuthorization(challengeDao.getAcmeAuthorization().getAcmeAuthorizationId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
            additionalHeaders.set("Link", "<" + authUri.toASCIIString() + ">;rel=\"up\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
    }

    @RequestMapping(value={"/{challengeId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> postChallenge(@RequestBody String requestBody, @PathVariable long challengeId) {
        LOG.debug("Received Challenge request ");
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            Optional challengeOpt = this.challengeRepository.findById((Object)challengeId);
            if (!challengeOpt.isPresent()) {
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
            if (challengeDao.getAcmeAuthorization().getOrder().getAccount().getAccountId() != acctDao.getAccountId()) {
                LOG.warn("Account of signing key {} does not match account id {} associated to given challenge{}", new Object[]{acctDao.getAccountId(), challengeDao.getAcmeAuthorization().getOrder().getAccount().getAccountId(), challengeId});
                ProblemDetail problem = new ProblemDetail(ACMEUtil.MALFORMED, "Account / Auth mismatch", HttpStatus.BAD_REQUEST, "", ACMEController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            LOG.debug("checking challenge {}", (Object)challengeDao.getId());
            boolean solved = false;
            if ("http-01".equals(challengeDao.getType())) {
                solved = this.checkChallengeHttp(challengeDao);
                if (solved) {
                    challengeDao.setStatus(ChallengeStatus.VALID);
                } else {
                    challengeDao.setStatus(ChallengeStatus.INVALID);
                }
                challengeDao.setValidated(Instant.now());
                this.challengeRepository.save((Object)challengeDao);
                LOG.debug("challengeDao set to '{}' at {}", (Object)challengeDao.getStatus().toString(), (Object)challengeDao.getValidated());
            } else {
                LOG.warn("Unexpected type '{}' of challenge{}", (Object)challengeDao.getType(), (Object)challengeId);
            }
            ChallengeResponse challenge = this.buildChallengeResponse(challengeDao);
            if (solved) {
                URI authUri = this.locationUriOfAuthorization(challengeDao.getAcmeAuthorization().getAcmeAuthorizationId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
                additionalHeaders.set("Link", "<" + authUri.toASCIIString() + ">;rel=\"up\"");
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
            }
            LOG.warn("validation of challenge{} of type '{}' failed", (Object)challengeId, (Object)challengeDao.getType());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(additionalHeaders)).body((Object)challenge);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    private boolean checkChallengeHttp(AcmeChallenge challengeDao) {
        int[] ports = new int[]{80, 5544, 8800};
        String token = challengeDao.getToken();
        String pkThumbprint = challengeDao.getAcmeAuthorization().getOrder().getAccount().getPublicKeyHash();
        String expectedContent = token + '.' + pkThumbprint;
        String fileNamePath = "/.well-known/acme-challenge/" + token;
        String host = challengeDao.getAcmeAuthorization().getValue();
        for (int port : ports) {
            try {
                String inputLine;
                URL url = new URL("http", host, port, fileNamePath);
                LOG.debug("Opening connection to  : " + url);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setConnectTimeout(2000);
                con.setRequestMethod("GET");
                con.setRequestProperty("User-Agent", "CA3S_ACME");
                int responseCode = con.getResponseCode();
                LOG.debug("\nSending 'GET' request to URL : " + url.toString());
                LOG.debug("Response Code : " + responseCode);
                if (responseCode != 200) {
                    LOG.info("read challenge responded with unexpected code : " + responseCode);
                    return false;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String actualContent = response.toString().trim();
                LOG.debug("read challenge response: " + actualContent);
                LOG.debug("expected content: '{}'", (Object)expectedContent);
                return expectedContent.equals(actualContent);
            }
            catch (UnknownHostException uhe) {
                LOG.debug("unable to resolve hostname ", (Throwable)uhe);
                return false;
            }
            catch (IOException ioe) {
                LOG.debug("exception occured reading challenge response on {}:{} for {}", new Object[]{host, port, challengeDao.getId(), ioe.getLocalizedMessage()});
            }
        }
        return false;
    }

    ChallengeResponse buildChallengeResponse(AcmeChallenge challengeDao) {
        ChallengeResponse challenge = new ChallengeResponse(challengeDao, this.locationUriOfChallenge(challengeDao.getId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).toString());
        return challenge;
    }

    private URI locationUriOfChallenge(long challengeId, UriComponentsBuilder uriBuilder) {
        return this.challengeResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path(Long.toString(challengeId)).build().normalize().toUri();
    }

    private URI locationUriOfAuthorization(long authorizationId, UriComponentsBuilder uriBuilder) {
        return this.authorizationResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path("..").path("/").path(Long.toString(authorizationId)).build().normalize().toUri();
    }
}

