/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.BPNMProcessInfo;
import de.trustable.ca3s.core.service.BPNMProcessInfoService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BPNMProcessInfoResource {
    private final Logger log = LoggerFactory.getLogger(BPNMProcessInfoResource.class);
    private static final String ENTITY_NAME = "bPNMProcessInfo";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final BPNMProcessInfoService bPNMProcessInfoService;

    public BPNMProcessInfoResource(BPNMProcessInfoService bPNMProcessInfoService) {
        this.bPNMProcessInfoService = bPNMProcessInfoService;
    }

    @PostMapping(value={"/bpnm-process-infos"})
    public ResponseEntity<BPNMProcessInfo> createBPNMProcessInfo(@Valid @RequestBody BPNMProcessInfo bPNMProcessInfo) throws URISyntaxException {
        this.log.debug("REST request to save BPNMProcessInfo : {}", (Object)bPNMProcessInfo);
        if (bPNMProcessInfo.getId() != null) {
            throw new BadRequestAlertException("A new bPNMProcessInfo cannot already have an ID", ENTITY_NAME, "idexists");
        }
        BPNMProcessInfo result = this.bPNMProcessInfoService.save(bPNMProcessInfo);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/bpnm-process-infos/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/bpnm-process-infos"})
    public ResponseEntity<BPNMProcessInfo> updateBPNMProcessInfo(@Valid @RequestBody BPNMProcessInfo bPNMProcessInfo) throws URISyntaxException {
        this.log.debug("REST request to update BPNMProcessInfo : {}", (Object)bPNMProcessInfo);
        if (bPNMProcessInfo.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        BPNMProcessInfo result = this.bPNMProcessInfoService.save(bPNMProcessInfo);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)bPNMProcessInfo.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/bpnm-process-infos"})
    public List<BPNMProcessInfo> getAllBPNMProcessInfos() {
        this.log.debug("REST request to get all BPNMProcessInfos");
        return this.bPNMProcessInfoService.findAll();
    }

    @GetMapping(value={"/bpnm-process-infos/{id}"})
    public ResponseEntity<BPNMProcessInfo> getBPNMProcessInfo(@PathVariable Long id) {
        this.log.debug("REST request to get BPNMProcessInfo : {}", (Object)id);
        Optional bPNMProcessInfo = this.bPNMProcessInfoService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)bPNMProcessInfo);
    }

    @DeleteMapping(value={"/bpnm-process-infos/{id}"})
    public ResponseEntity<Void> deleteBPNMProcessInfo(@PathVariable Long id) {
        this.log.debug("REST request to delete BPNMProcessInfo : {}", (Object)id);
        this.bPNMProcessInfoService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

