/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import java.util.List;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProtectedContentUtil {
    private final Logger log = LoggerFactory.getLogger(ProtectedContentUtil.class);
    private BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
    @Autowired
    private ProtectedContentRepository protContentRepository;

    public ProtectedContentUtil(@Value(value="${protectionSecret:S3cr3t}") String protectionSecret) {
        if (protectionSecret == null || protectionSecret.trim().length() == 0) {
            throw new UnsupportedOperationException("Configuration parameter 'protectionSecret' missing or invalid");
        }
        this.log.debug("using protection  secret '{}'", (Object)protectionSecret);
        this.textEncryptor.setPassword(protectionSecret);
    }

    public String protectString(String content) {
        return this.textEncryptor.encrypt(content);
    }

    public String unprotectString(String protectedContent) {
        return this.textEncryptor.decrypt(protectedContent);
    }

    public ProtectedContent createProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId) {
        ProtectedContent pc = new ProtectedContent();
        pc.setContentBase64(this.protectString(plainText));
        pc.setType(pct);
        pc.setRelationType(crt);
        pc.setRelatedId(Long.valueOf(connectionId));
        this.protContentRepository.save((Object)pc);
        return pc;
    }

    public List<ProtectedContent> retrieveProtectedContent(ProtectedContentType type, ContentRelationType crt, long id) {
        return this.protContentRepository.findByTypeRelationId(type, crt, Long.valueOf(id));
    }
}

