/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.BPNMProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.PipelineAttribute;
import de.trustable.ca3s.core.domain.enumeration.ARACardinalityRestriction;
import de.trustable.ca3s.core.domain.enumeration.RDNCardinalityRestriction;
import de.trustable.ca3s.core.repository.BPNMProcessInfoRepository;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.PipelineAttributeRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.dto.ACMEConfigItems;
import de.trustable.ca3s.core.service.dto.ARARestriction;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.dto.RDNRestriction;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.util.OidNameMapper;
import de.trustable.util.Pkcs10RequestHolder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PipelineUtil {
    public static final String RESTR_C_CARDINALITY = "RESTR_C_CARDINALITY";
    public static final String RESTR_C_TEMPLATE = "RESTR_C_TEMPLATE";
    public static final String RESTR_C_REGEXMATCH = "RESTR_C_REGEXMATCH";
    public static final String RESTR_CN_CARDINALITY = "RESTR_CN_CARDINALITY";
    public static final String RESTR_CN_TEMPLATE = "RESTR_CN_TEMPLATE";
    public static final String RESTR_CN_REGEXMATCH = "RESTR_CN_REGEXMATCH";
    public static final String RESTR_O_CARDINALITY = "RESTR_O_CARDINALITY";
    public static final String RESTR_O_TEMPLATE = "RESTR_O_TEMPLATE";
    public static final String RESTR_O_REGEXMATCH = "RESTR_O_REGEXMATCH";
    public static final String RESTR_OU_CARDINALITY = "RESTR_OU_CARDINALITY";
    public static final String RESTR_OU_TEMPLATE = "RESTR_OU_TEMPLATE";
    public static final String RESTR_OU_REGEXMATCH = "RESTR_OU_REGEXMATCH";
    public static final String RESTR_L_CARDINALITY = "RESTR_L_CARDINALITY";
    public static final String RESTR_L_TEMPLATE = "RESTR_L_TEMPLATE";
    public static final String RESTR_L_REGEXMATCH = "RESTR_L_REGEXMATCH";
    public static final String RESTR_S_CARDINALITY = "RESTR_S_CARDINALITY";
    public static final String RESTR_S_TEMPLATE = "RESTR_S_TEMPLATE";
    public static final String RESTR_S_REGEXMATCH = "RESTR_S_REGEXMATCH";
    public static final String RESTR_SAN_CARDINALITY = "RESTR_SAN_CARDINALITY";
    public static final String RESTR_SAN_TEMPLATE = "RESTR_SAN_TEMPLATE";
    public static final String RESTR_SAN_REGEXMATCH = "RESTR_SAN_REGEXMATCH";
    public static final String RESTR_ARA_PREFIX = "RESTR_ARA_";
    public static final String RESTR_ARA_PATTERN = "RESTR_ARA_(.*)_(.*)";
    public static final String RESTR_ARA_NAME = "NAME";
    public static final String RESTR_ARA_CARDINALITY = "CARDINALITY";
    public static final String RESTR_ARA_TEMPLATE = "TEMPLATE";
    public static final String RESTR_ARA_REGEXMATCH = "REGEXMATCH";
    public static final String ALLOW_IP_AS_SUBJECT = "ALLOW_IP_AS_SUBJECT";
    public static final String ALLOW_IP_AS_SAN = "ALLOW_IP_AS_SAN";
    public static final String TO_PENDIND_ON_FAILED_RESTRICTIONS = "TO_PENDIND_ON_FAILED_RESTRICTIONS";
    public static final String ACME_ALLOW_CHALLENGE_HTTP01 = "ACME_ALLOW_CHALLENGE_HTTP01";
    public static final String ACME_ALLOW_CHALLENGE_DNS = "ACME_ALLOW_CHALLENGE_DNS";
    public static final String ACME_ALLOW_CHALLENGE_WILDCARDS = "ACME_ALLOW_WILDCARDS";
    public static final String ACME_CHECK_CAA = "ACME_CHECK_CAA";
    public static final String ACME_NAME_CAA = "ACME_NAME_CAA";
    public static final String ACME_PROCESS_ACCOUNT_VALIDATION = "ACME_PROCESS_ACCOUNT_VALIDATION";
    public static final String ACME_PROCESS_ORDER_VALIDATION = "ACME_PROCESS_ORDER_VALIDATION";
    public static final String ACME_PROCESS_CHALLENGE_VALIDATION = "ACME_PROCESS_CHALLENGE_VALIDATION";
    Logger LOG = LoggerFactory.getLogger(PipelineUtil.class);
    @Autowired
    private CAConnectorConfigRepository caConnRepository;
    @Autowired
    private PipelineRepository pipelineRepository;
    @Autowired
    private PipelineAttributeRepository pipelineAttRepository;
    @Autowired
    private BPNMProcessInfoRepository bpmnPIRepository;

    public PipelineView from(Pipeline pipeline) {
        PipelineView pv = new PipelineView();
        pv.setId(pipeline.getId());
        pv.setName(pipeline.getName());
        pv.setType(pipeline.getType());
        pv.setDescription(pipeline.getDescription());
        pv.setApprovalRequired(pipeline.isApprovalRequired());
        pv.setUrlPart(pipeline.getUrlPart());
        if (pipeline.getCaConnector() != null) {
            pv.setCaConnectorName(pipeline.getCaConnector().getName());
        }
        if (pipeline.getProcessInfo() != null) {
            pv.setProcessInfoName(pipeline.getProcessInfo().getName());
        }
        RDNRestriction[] rdnRestrictArr = new RDNRestriction[7];
        RDNRestriction rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("C");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv.setRestriction_C(rdnRestrict);
        rdnRestrictArr[0] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("CN");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.NOT_ALLOWED);
        pv.setRestriction_CN(rdnRestrict);
        rdnRestrictArr[1] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("O");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.NOT_ALLOWED);
        pv.setRestriction_O(rdnRestrict);
        rdnRestrictArr[2] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("OU");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.NOT_ALLOWED);
        pv.setRestriction_OU(rdnRestrict);
        rdnRestrictArr[3] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("L");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.NOT_ALLOWED);
        pv.setRestriction_L(rdnRestrict);
        rdnRestrictArr[4] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("ST");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.NOT_ALLOWED);
        pv.setRestriction_S(rdnRestrict);
        rdnRestrictArr[5] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("SAN");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.NOT_ALLOWED);
        pv.setRestriction_SAN(rdnRestrict);
        rdnRestrictArr[6] = rdnRestrict;
        pv.setRdnRestrictions(rdnRestrictArr);
        pv.setAraRestrictions(new ARARestriction[0]);
        ACMEConfigItems acmeConfigItems = new ACMEConfigItems();
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            if (ACME_ALLOW_CHALLENGE_HTTP01.equals(plAtt.getName())) {
                acmeConfigItems.setAllowChallengeHTTP01(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (ACME_ALLOW_CHALLENGE_DNS.equals(plAtt.getName())) {
                acmeConfigItems.setAllowChallengeDNS(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (ACME_ALLOW_CHALLENGE_WILDCARDS.equals(plAtt.getName())) {
                acmeConfigItems.setAllowWildcards(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (ACME_CHECK_CAA.equals(plAtt.getName())) {
                acmeConfigItems.setCheckCAA(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (ACME_NAME_CAA.equals(plAtt.getName())) {
                acmeConfigItems.setCaNameCAA(plAtt.getValue());
                continue;
            }
            if (ALLOW_IP_AS_SUBJECT.equals(plAtt.getName())) {
                pv.setIpAsSubjectAllowed(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (ALLOW_IP_AS_SAN.equals(plAtt.getName())) {
                pv.setIpAsSANAllowed(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (RESTR_C_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_C().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_C_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_C().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_C_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_C().setRegExMatch(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (RESTR_CN_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_CN().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_CN_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_CN().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_CN_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_CN().setRegExMatch(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (RESTR_O_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_O().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_O_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_O().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_O_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_O().setRegExMatch(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (RESTR_OU_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_OU().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_OU_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_OU().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_OU_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_OU().setRegExMatch(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (RESTR_L_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_L().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_L_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_L().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_L_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_L().setRegExMatch(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (RESTR_S_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_S().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_S_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_S().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_S_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_S().setRegExMatch(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (RESTR_SAN_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_SAN().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_SAN_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_SAN().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_SAN_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_SAN().setRegExMatch(Boolean.valueOf(plAtt.getValue()).booleanValue());
                continue;
            }
            if (!TO_PENDIND_ON_FAILED_RESTRICTIONS.equals(plAtt.getName())) continue;
            pv.setToPendingOnFailedRestrictions(Boolean.valueOf(plAtt.getValue()).booleanValue());
        }
        pv.setAcmeConfigItems(acmeConfigItems);
        Pattern araPattern = Pattern.compile(RESTR_ARA_PATTERN);
        int nARA = 0;
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            int araIdx;
            Matcher m;
            if (!plAtt.getName().startsWith(RESTR_ARA_PREFIX) || !(m = araPattern.matcher(plAtt.getName())).find() || (araIdx = Integer.parseInt(m.group(1))) + 1 <= nARA) continue;
            nARA = araIdx + 1;
        }
        this.LOG.debug("#{} ARA itmes found", (Object)nARA);
        ARARestriction[] araRestrictions = new ARARestriction[nARA];
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            if (!plAtt.getName().startsWith(RESTR_ARA_PREFIX)) continue;
            this.LOG.debug("ARA itmes : {}", (Object)plAtt.getName());
            Matcher m = araPattern.matcher(plAtt.getName());
            if (!m.find()) continue;
            int araIdx = Integer.parseInt(m.group(1));
            this.LOG.debug("araIdx: {}", (Object)araIdx);
            if (araRestrictions[araIdx] == null) {
                araRestrictions[araIdx] = new ARARestriction();
            }
            ARARestriction araRestriction = araRestrictions[araIdx];
            String namePart = m.group(2);
            this.LOG.debug("ARA namePart : {}", (Object)namePart);
            if (RESTR_ARA_NAME.equals(namePart)) {
                araRestriction.setName(plAtt.getValue());
                continue;
            }
            if (RESTR_ARA_CARDINALITY.equals(namePart)) {
                araRestriction.setCardinalityRestriction(ARACardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_ARA_TEMPLATE.equals(namePart)) {
                araRestriction.setContentTemplate(plAtt.getValue());
                continue;
            }
            if (!RESTR_ARA_REGEXMATCH.equals(namePart)) continue;
            araRestriction.setRegExMatch(Boolean.valueOf(plAtt.getValue()).booleanValue());
        }
        pv.setAraRestrictions(araRestrictions);
        return pv;
    }

    public Pipeline toPipeline(PipelineView pv) {
        Pipeline p;
        if (pv.getId() != null) {
            Optional optP = this.pipelineRepository.findById((Object)pv.getId());
            if (optP.isPresent()) {
                p = (Pipeline)optP.get();
                this.pipelineAttRepository.deleteAll((Iterable)p.getPipelineAttributes());
            } else {
                p = new Pipeline();
            }
        } else {
            p = new Pipeline();
        }
        p.setId(pv.getId());
        p.setName(pv.getName());
        p.setDescription(pv.getDescription());
        p.setType(pv.getType());
        p.setUrlPart(pv.getUrlPart());
        p.setApprovalRequired(pv.getApprovalRequired());
        List ccc = this.caConnRepository.findByName(pv.getCaConnectorName());
        if (ccc.isEmpty()) {
            p.setCaConnector(null);
        } else {
            p.setCaConnector((CAConnectorConfig)ccc.get(0));
        }
        Optional bpiOpt = this.bpmnPIRepository.findByName(pv.getProcessInfoName());
        if (bpiOpt.isPresent()) {
            p.setProcessInfo((BPNMProcessInfo)bpiOpt.get());
        } else {
            p.setProcessInfo(null);
        }
        HashSet pipelineAttributes = new HashSet();
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_C_CARDINALITY, pv.getRestriction_C().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_C_TEMPLATE, pv.getRestriction_C().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_C_REGEXMATCH, Boolean.valueOf(pv.getRestriction_C().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_CN_CARDINALITY, pv.getRestriction_CN().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_CN_TEMPLATE, pv.getRestriction_CN().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_CN_REGEXMATCH, Boolean.valueOf(pv.getRestriction_CN().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_O_CARDINALITY, pv.getRestriction_O().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_O_TEMPLATE, pv.getRestriction_O().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_O_REGEXMATCH, Boolean.valueOf(pv.getRestriction_O().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_OU_CARDINALITY, pv.getRestriction_OU().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_OU_TEMPLATE, pv.getRestriction_OU().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_OU_REGEXMATCH, Boolean.valueOf(pv.getRestriction_OU().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_L_CARDINALITY, pv.getRestriction_L().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_L_TEMPLATE, pv.getRestriction_L().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_L_REGEXMATCH, Boolean.valueOf(pv.getRestriction_L().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_S_CARDINALITY, pv.getRestriction_S().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_S_TEMPLATE, pv.getRestriction_S().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_S_REGEXMATCH, Boolean.valueOf(pv.getRestriction_S().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_SAN_CARDINALITY, pv.getRestriction_SAN().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_SAN_TEMPLATE, pv.getRestriction_SAN().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, RESTR_SAN_REGEXMATCH, Boolean.valueOf(pv.getRestriction_SAN().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, ALLOW_IP_AS_SUBJECT, Boolean.valueOf(pv.isIpAsSubjectAllowed()));
        this.addPipelineAttribute(pipelineAttributes, p, ALLOW_IP_AS_SAN, Boolean.valueOf(pv.isIpAsSANAllowed()));
        this.addPipelineAttribute(pipelineAttributes, p, TO_PENDIND_ON_FAILED_RESTRICTIONS, Boolean.valueOf(pv.isToPendingOnFailedRestrictions()));
        if (pv.getAcmeConfigItems() == null) {
            ACMEConfigItems acmeConfigItems = new ACMEConfigItems();
            pv.setAcmeConfigItems(acmeConfigItems);
        }
        this.addPipelineAttribute(pipelineAttributes, p, ACME_ALLOW_CHALLENGE_HTTP01, Boolean.valueOf(pv.getAcmeConfigItems().isAllowChallengeHTTP01()));
        this.addPipelineAttribute(pipelineAttributes, p, ACME_ALLOW_CHALLENGE_DNS, Boolean.valueOf(pv.getAcmeConfigItems().isAllowChallengeDNS()));
        this.addPipelineAttribute(pipelineAttributes, p, ACME_ALLOW_CHALLENGE_WILDCARDS, Boolean.valueOf(pv.getAcmeConfigItems().isAllowWildcards()));
        this.addPipelineAttribute(pipelineAttributes, p, ACME_CHECK_CAA, Boolean.valueOf(pv.getAcmeConfigItems().isCheckCAA()));
        this.addPipelineAttribute(pipelineAttributes, p, ACME_NAME_CAA, pv.getAcmeConfigItems().getCaNameCAA());
        p.setPipelineAttributes(pipelineAttributes);
        ARARestriction[] araRestrictions = pv.getAraRestrictions();
        for (int i = 0; i < araRestrictions.length; ++i) {
            ARARestriction araRestriction = araRestrictions[i];
            String araName = araRestriction.getName();
            if (araName == null || araName.trim().isEmpty()) continue;
            this.addPipelineAttribute(pipelineAttributes, p, RESTR_ARA_PREFIX + i + "_" + RESTR_ARA_NAME, araName.trim());
            this.addPipelineAttribute(pipelineAttributes, p, RESTR_ARA_PREFIX + i + "_" + RESTR_ARA_CARDINALITY, araRestriction.getCardinalityRestriction().name());
            this.addPipelineAttribute(pipelineAttributes, p, RESTR_ARA_PREFIX + i + "_" + RESTR_ARA_TEMPLATE, araRestriction.getContentTemplate());
            this.addPipelineAttribute(pipelineAttributes, p, RESTR_ARA_PREFIX + i + "_" + RESTR_ARA_REGEXMATCH, Boolean.valueOf(araRestriction.isRegExMatch()));
        }
        this.pipelineAttRepository.saveAll((Iterable)p.getPipelineAttributes());
        this.pipelineRepository.save((Object)p);
        return p;
    }

    public void addPipelineAttribute(Set<PipelineAttribute> pipelineAttributes, Pipeline p, String name, Boolean value) {
        this.addPipelineAttribute(pipelineAttributes, p, name, value.toString());
    }

    public void addPipelineAttribute(Set<PipelineAttribute> pipelineAttributes, Pipeline p, String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            new Exception("name == null");
            return;
        }
        if (value == null || value.trim().isEmpty()) {
            return;
        }
        PipelineAttribute pAtt = new PipelineAttribute();
        pAtt.setPipeline(p);
        pAtt.setName(name);
        pAtt.setValue(value);
        pipelineAttributes.add(pAtt);
    }

    public boolean isPipelineRestrictionsResolved(Pipeline p, Pkcs10RequestHolder p10ReqHolder, List<String> messageList) {
        return this.isPipelineRestrictionsResolved(this.from(p), p10ReqHolder, messageList);
    }

    public boolean isPipelineRestrictionsResolved(PipelineView pv, Pkcs10RequestHolder p10ReqHolder, List<String> messageList) {
        boolean outcome = true;
        RDN[] rdnArr = p10ReqHolder.getSubjectRDNs();
        if (!this.checkRestrictions(BCStyle.C, pv.getRestriction_C(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.CN, pv.getRestriction_CN(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.O, pv.getRestriction_O(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.OU, pv.getRestriction_OU(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.L, pv.getRestriction_L(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.ST, pv.getRestriction_S(), rdnArr, messageList)) {
            outcome = false;
        }
        Set gNameSet = CSRUtil.getSANList((Attribute[])p10ReqHolder.getReqAttributes());
        this.LOG.debug("#" + gNameSet.size() + " SANs present");
        if (!this.checkRestrictions(pv.getRestriction_SAN(), gNameSet, messageList)) {
            outcome = false;
        }
        if (!pv.isIpAsSubjectAllowed() && this.isSubjectIP(rdnArr, messageList)) {
            outcome = false;
        }
        if (!pv.isIpAsSANAllowed() && this.hasIPinSANList(gNameSet, messageList)) {
            outcome = false;
        }
        return outcome;
    }

    private boolean hasIPinSANList(Set<GeneralName> gNameSet, List<String> messageList) {
        boolean outcome = false;
        for (GeneralName gn : gNameSet) {
            if (7 != gn.getTagNo()) continue;
            String sanValue = gn.getName().toString();
            messageList.add("SAN '" + sanValue + "' is an IP address");
            outcome = true;
        }
        return outcome;
    }

    private boolean checkRestrictions(RDNRestriction restriction, Set<GeneralName> gNameSet, List<String> messageList) {
        String msg;
        if (restriction == null) {
            return true;
        }
        boolean outcome = true;
        String template = "";
        this.LOG.debug("checking SANs");
        boolean hasTemplate = false;
        if (restriction.getContentTemplate() != null) {
            template = restriction.getContentTemplate().trim();
            hasTemplate = !template.isEmpty();
        }
        int n = 0;
        for (GeneralName gn : gNameSet) {
            ++n;
            if (!hasTemplate) continue;
            String value = gn.getName().toString().trim();
            if (restriction.isRegExMatch()) {
                boolean evalResult = false;
                try {
                    evalResult = value.matches(template);
                }
                catch (PatternSyntaxException pse) {
                    this.LOG.warn("pattern '" + template + "' is not valid");
                }
                if (evalResult) continue;
                String msg2 = "restriction mismatch: SAN '" + value + "' does not match regular expression '" + template + "' !";
                messageList.add(msg2);
                this.LOG.debug(msg2);
                outcome = false;
                continue;
            }
            if (template.equalsIgnoreCase(value)) continue;
            String msg3 = "restriction mismatch: SAN '" + value + "' does not match expected value '" + template + "' !";
            messageList.add(msg3);
            this.LOG.debug(msg3);
            outcome = false;
        }
        RDNCardinalityRestriction cardinality = restriction.getCardinalityRestriction();
        if (RDNCardinalityRestriction.NOT_ALLOWED.equals((Object)cardinality)) {
            if (n > 0) {
                msg = "restrcition mismatch: A SAN MUST NOT occur!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE.equals((Object)cardinality)) {
            if (n == 0) {
                msg = "restrcition mismatch: SAN MUST occur once, missing here!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
            if (n != 1) {
                msg = "restrcition mismatch: SAN MUST occur exactly once, found " + n + " times!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE_OR_MANY.equals((Object)cardinality)) {
            if (n == 0) {
                msg = "restrcition mismatch: SAns MUST occur once or more, missing here!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ZERO_OR_ONE.equals((Object)cardinality) && n > 1) {
            msg = "restrcition mismatch: SANs MUST occur zero or once, found " + n + " times!";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        return outcome;
    }

    private boolean checkRestrictions(ASN1ObjectIdentifier restricted, RDNRestriction restriction, RDN[] rdnArr, List<String> messageList) {
        if (restriction == null) {
            return true;
        }
        boolean outcome = true;
        String template = "";
        String restrictedName = OidNameMapper.lookupOid((String)restricted.toString());
        this.LOG.debug("checking element '{}'", (Object)restrictedName);
        boolean hasTemplate = false;
        if (restriction.getContentTemplate() != null) {
            template = restriction.getContentTemplate().trim();
            hasTemplate = !template.isEmpty();
        }
        int n = 0;
        for (RDN rdn : rdnArr) {
            AttributeTypeAndValue atv = rdn.getFirst();
            if (!restricted.equals((ASN1Primitive)atv.getType())) continue;
            ++n;
            if (!hasTemplate) continue;
            String value = atv.getValue().toString().trim();
            if (restriction.isRegExMatch()) {
                boolean evalResult = false;
                try {
                    evalResult = value.matches(template);
                }
                catch (PatternSyntaxException pse) {
                    this.LOG.warn("pattern '" + template + "' is not valid");
                }
                if (evalResult) continue;
                String msg = "restriction mismatch: '" + value + "' does not match regular expression '" + template + "' !";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
                continue;
            }
            if (template.equalsIgnoreCase(value)) continue;
            String msg = "restriction mismatch: '" + value + "' does not match expected value '" + template + "' !";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        RDNCardinalityRestriction cardinality = restriction.getCardinalityRestriction();
        if (RDNCardinalityRestriction.NOT_ALLOWED.equals((Object)cardinality)) {
            if (n > 0) {
                String msg = "restrcition mismatch: '" + restrictedName + "' MUST NOT occur!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE.equals((Object)cardinality)) {
            if (n == 0) {
                String msg = "restrcition mismatch: '" + restrictedName + "' MUST occur once, missing here!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
            if (n != 1) {
                String msg = "restrcition mismatch: '" + restrictedName + "' MUST occur exactly once, found " + n + " times!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE_OR_MANY.equals((Object)cardinality)) {
            if (n == 0) {
                String msg = "restrcition mismatch: '" + restrictedName + "' MUST occur once or more, missing here!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ZERO_OR_ONE.equals((Object)cardinality) && n > 1) {
            String msg = "restrcition mismatch: '" + restrictedName + "' MUST occur zero or once, found " + n + " times!";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        return outcome;
    }

    private boolean isSubjectIP(RDN[] rdnArr, List<String> messageList) {
        for (RDN rdn : rdnArr) {
            AttributeTypeAndValue atv = rdn.getFirst();
            if (!BCStyle.CN.equals((ASN1Primitive)atv.getType())) continue;
            String value = atv.getValue().toString().trim();
            InetAddressValidator inv = InetAddressValidator.getInstance();
            if (inv.isValidInet4Address(value)) {
                messageList.add("CommonName '" + value + "' is valid IP4 address");
                return true;
            }
            if (!inv.isValidInet6Address(value)) continue;
            messageList.add("CommonName '" + value + "' is valid IP6 address");
            return true;
        }
        return false;
    }
}

