/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.enumeration.CAConnectorType;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.service.adcs.ADCSConnector;
import de.trustable.ca3s.core.service.cmp.CaCmpConnector;
import de.trustable.ca3s.core.service.dir.DirectoryConnector;
import de.trustable.ca3s.core.service.util.CAStatus;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CaInternalConnector;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.bouncycastle.asn1.x509.CRLReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CaConnectorAdapter {
    Logger LOGGER = LoggerFactory.getLogger(CaConnectorAdapter.class);
    @Autowired
    private ADCSConnector adcsConnector;
    @Autowired
    private CaCmpConnector cmpConnector;
    @Autowired
    private CaInternalConnector internalConnector;
    @Autowired
    private DirectoryConnector dirConnector;
    @Autowired
    private CSRUtil csrUtil;

    public CAStatus getStatus(CAConnectorConfig caConfig) {
        if (caConfig == null) {
            this.LOGGER.debug("CAConnectorType need caConfig != null ");
            return CAStatus.Unknown;
        }
        if (CAConnectorType.ADCS.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType ADCS at " + caConfig.getCaUrl());
            return this.adcsConnector.getStatus(caConfig);
        }
        if (CAConnectorType.CMP.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType CMP at " + caConfig.getCaUrl());
            return this.cmpConnector.getStatus(caConfig);
        }
        if (CAConnectorType.INTERNAL.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType INTERNAL is Active");
            return CAStatus.Active;
        }
        if (CAConnectorType.DIRECTORY.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType DIRECTORY for " + caConfig.getCaUrl());
            return this.dirConnector.getStatus(caConfig);
        }
        this.LOGGER.warn("unexpected ca connector type '" + caConfig.getCaConnectorType() + "' !");
        return CAStatus.Unknown;
    }

    public Certificate signCertificateRequest(String csrBase64, CAConnectorConfig caConfig) throws GeneralSecurityException, IOException {
        CSR csr = this.csrUtil.buildCSR(csrBase64, "SYSTEM", this.csrUtil.parseBase64CSR(csrBase64), PipelineType.INTERNAL, null);
        return this.signCertificateRequest(csr, caConfig);
    }

    public Certificate signCertificateRequest(CSR csr, CAConnectorConfig caConfig) throws GeneralSecurityException {
        if (caConfig == null) {
            throw new GeneralSecurityException("CA connector not selected !");
        }
        if (CAConnectorType.ADCS.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType ADCS at " + caConfig.getCaUrl());
            return this.adcsConnector.signCertificateRequest(csr, caConfig);
        }
        if (CAConnectorType.CMP.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType CMP at " + caConfig.getCaUrl());
            return this.cmpConnector.signCertificateRequest(csr, caConfig);
        }
        if (CAConnectorType.INTERNAL.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType INTERNAL ");
            return this.internalConnector.signCertificateRequest(csr, caConfig);
        }
        throw new GeneralSecurityException("unexpected ca connector type '" + caConfig.getCaConnectorType() + "' !");
    }

    @Transactional
    public void revokeCertificate(Certificate certificateDao, CRLReason crlReason, Date revocationDate, CAConnectorConfig caConfig) throws GeneralSecurityException {
        if (caConfig == null) {
            throw new GeneralSecurityException("CA connector not selected !");
        }
        if (CAConnectorType.ADCS.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType ADCS at " + caConfig.getCaUrl());
            this.adcsConnector.revokeCertificate(certificateDao, crlReason, revocationDate, caConfig);
        } else if (CAConnectorType.CMP.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType CMP at " + caConfig.getCaUrl());
            this.cmpConnector.revokeCertificate(certificateDao, crlReason, revocationDate, caConfig);
        } else if (CAConnectorType.INTERNAL.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType INTERNAL ");
            this.internalConnector.revokeCertificate(certificateDao, crlReason, revocationDate, caConfig);
        } else {
            throw new GeneralSecurityException("unexpected ca connector type '" + caConfig.getCaConnectorType() + "' !");
        }
    }
}

