/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.UserPreference;
import de.trustable.ca3s.core.repository.UserPreferenceRepository;
import de.trustable.ca3s.core.service.UserPreferenceService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserPreferenceServiceImpl
implements UserPreferenceService {
    private final Logger log = LoggerFactory.getLogger(UserPreferenceServiceImpl.class);
    private final UserPreferenceRepository userPreferenceRepository;

    public UserPreferenceServiceImpl(UserPreferenceRepository userPreferenceRepository) {
        this.userPreferenceRepository = userPreferenceRepository;
    }

    public UserPreference save(UserPreference userPreference) {
        this.log.debug("Request to save UserPreference : {}", (Object)userPreference);
        return (UserPreference)this.userPreferenceRepository.save((Object)userPreference);
    }

    @Transactional(readOnly=true)
    public List<UserPreference> findAll() {
        this.log.debug("Request to get all UserPreferences");
        return this.userPreferenceRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<UserPreference> findOne(Long id) {
        this.log.debug("Request to get UserPreference : {}", (Object)id);
        return this.userPreferenceRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete UserPreference : {}", (Object)id);
        this.userPreferenceRepository.deleteById((Object)id);
    }
}

