/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.PipelineViewService;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PipelineViewServiceImpl
implements PipelineViewService {
    private final Logger log = LoggerFactory.getLogger(PipelineViewServiceImpl.class);
    private final PipelineRepository pipelineRepository;
    private final PipelineUtil pvUtil;

    public PipelineViewServiceImpl(PipelineRepository pipelineRepository, PipelineUtil pvUtil) {
        this.pipelineRepository = pipelineRepository;
        this.pvUtil = pvUtil;
    }

    public PipelineView save(PipelineView pipelineView) {
        this.log.debug("Request to save Pipeline : {}", (Object)pipelineView);
        Pipeline p = this.pvUtil.toPipeline(pipelineView);
        this.pipelineRepository.save((Object)p);
        return pipelineView;
    }

    @Transactional(readOnly=true)
    public List<PipelineView> findAll() {
        this.log.debug("Request to get all Pipelines");
        ArrayList<PipelineView> pvList = new ArrayList<PipelineView>();
        for (Pipeline p : this.pipelineRepository.findAll()) {
            PipelineView pv = this.pvUtil.from(p);
            pvList.add(pv);
        }
        return pvList;
    }

    @Transactional(readOnly=true)
    public Optional<PipelineView> findOne(Long id) {
        this.log.debug("Request to get Pipeline : {}", (Object)id);
        Optional optP = this.pipelineRepository.findById((Object)id);
        if (optP.isPresent()) {
            return Optional.of(this.pvUtil.from((Pipeline)optP.get()));
        }
        return Optional.empty();
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Pipeline : {}", (Object)id);
        this.pipelineRepository.deleteById((Object)id);
    }
}

