/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dir;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.ImportedURL;
import de.trustable.ca3s.core.repository.CertificateAttributeRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.ImportedURLRepository;
import de.trustable.ca3s.core.schedule.ImportInfo;
import de.trustable.ca3s.core.service.dir.CertificateCrawler;
import de.trustable.ca3s.core.service.util.CAStatus;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.TransactionHandler;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.crawler.CrawlController;
import edu.uci.ics.crawler4j.fetcher.PageFetcher;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtConfig;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtServer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirectoryConnector {
    private static final String FILE_PREFIX = "file://";
    private static final String IMPORT_SELECTOR_REGEX = ".*\\.(cer|cert|crt|pem)";
    private static final long MAX_IMPORTS_MILLISECONDS = 300000L;
    Logger LOGGER = LoggerFactory.getLogger(DirectoryConnector.class);
    @Autowired
    CertificateUtil certUtil;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private CertificateAttributeRepository certificateAttributeRepository;
    @Autowired
    private ImportedURLRepository importedURLRepository;
    @Autowired
    private TransactionHandler transactionHandler;

    public CAStatus getStatus(CAConnectorConfig caConfig) {
        File dir = new File(this.getFilename(caConfig));
        if (dir.exists() && dir.canRead()) {
            return CAStatus.Active;
        }
        return CAStatus.Deactivated;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int retrieveCertificates(CAConnectorConfig caConfig) throws IOException {
        String regEx;
        ImportInfo importInfo = new ImportInfo();
        String string = regEx = caConfig.getSelector() != null && caConfig.getSelector().trim().length() > 0 ? caConfig.getSelector().trim() : IMPORT_SELECTOR_REGEX;
        if (caConfig.getCaUrl() == null) {
            this.LOGGER.warn("in retrieveCertificates: url missing");
            return 0;
        }
        String url = caConfig.getCaUrl().toLowerCase();
        if (url.startsWith("http://") || url.startsWith("https://")) {
            CrawlConfig config = new CrawlConfig();
            Path tmpFolder = Files.createTempDirectory("crawler4j", new FileAttribute[0]);
            config.setCrawlStorageFolder(tmpFolder.toString());
            int numberOfCrawlers = 1;
            config.setIncludeBinaryContentInCrawling(true);
            List<String> crawlDomains = Arrays.asList(caConfig.getCaUrl());
            PageFetcher pageFetcher = new PageFetcher(config);
            RobotstxtConfig robotstxtConfig = new RobotstxtConfig();
            RobotstxtServer robotstxtServer = new RobotstxtServer(robotstxtConfig, pageFetcher);
            try {
                CrawlController controller = new CrawlController(config, pageFetcher, robotstxtServer);
                for (String domain : crawlDomains) {
                    controller.addSeed(domain);
                }
                CrawlController.WebCrawlerFactory factory = () -> new CertificateCrawler(crawlDomains, regEx, this.certUtil, importInfo);
                controller.start(factory, numberOfCrawlers);
            }
            catch (Exception e) {
                this.LOGGER.info("problem building crawler for '{}'", (Object)caConfig.getCaUrl());
            }
        } else {
            File dir = new File(this.getFilename(caConfig));
            this.LOGGER.debug("in retrieveCertificates for directory '{}' using regex '{}'", (Object)dir, (Object)regEx);
            Set certSet = this.listFilesUsingFileWalkAndVisitor(dir.getAbsolutePath(), regEx);
            long startTime = System.currentTimeMillis();
            for (String filename : certSet) {
                this.transactionHandler.runInNewTransaction(() -> this.importCertifiateFromFile(filename, importInfo));
                if (System.currentTimeMillis() - startTime <= 300000L) continue;
                this.LOGGER.debug("retrieveCertificates: imported for more than {} sec., delaying ...", (Object)300L);
                break;
            }
        }
        return importInfo.getImported();
    }

    public ImportInfo importCertifiateFromFile(String filename, ImportInfo importInfo) {
        try {
            File certFile = new File(filename);
            Instant lastChangeDate = Instant.ofEpochMilli(certFile.lastModified() / 1000L * 1000L);
            List impUrlList = this.importedURLRepository.findEntityByUrl(certFile.toURI().toString());
            if (impUrlList.isEmpty()) {
                try {
                    this.LOGGER.debug("new certificate '{}' found, importing ...", (Object)filename);
                    byte[] content = Files.readAllBytes(Paths.get(filename, new String[0]));
                    this.certUtil.createCertificate(content, null, null, false, filename);
                }
                catch (IOException | GeneralSecurityException e) {
                    this.LOGGER.info("reading and importing certificate from '{}' causes {}", (Object)filename, (Object)e.getLocalizedMessage());
                }
                ImportedURL impUrl = new ImportedURL();
                impUrl.setName(certFile.toURI().toString());
                impUrl.setImportDate(lastChangeDate);
                this.importedURLRepository.save((Object)impUrl);
                this.LOGGER.debug("certificate imported from '{}'", (Object)filename);
                importInfo.incImported();
                return importInfo;
            }
            ImportedURL impUrl = (ImportedURL)impUrlList.get(0);
            if (impUrl.getImportDate().getEpochSecond() != lastChangeDate.getEpochSecond()) {
                this.LOGGER.debug("ImportedURL for '{}' has a different import date {} compared to the files lastChangeDate {}", new Object[]{impUrl.getName(), impUrl.getImportDate().getEpochSecond(), lastChangeDate.getEpochSecond()});
            }
            importInfo.incRejected();
            return importInfo;
        }
        catch (Throwable th) {
            this.LOGGER.debug("certificate import failed", th);
            return null;
        }
    }

    Set<String> listFilesUsingFileWalkAndVisitor(String dir, String regEx) throws IOException {
        HashSet<String> fileList = new HashSet<String>();
        File target = new File(dir);
        if (!target.exists()) {
            this.LOGGER.warn("certificate import from '{}' failed, directory does not exist.", (Object)dir);
            return fileList;
        }
        if (!target.canRead()) {
            this.LOGGER.warn("certificate import from '{}' failed, no read access.", (Object)dir);
            return fileList;
        }
        Pattern pattern = Pattern.compile(regEx);
        Files.walkFileTree(Paths.get(dir, new String[0]), (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        return fileList;
    }

    private String getFilename(CAConnectorConfig caConfig) {
        String url;
        String filename = url = caConfig.getCaUrl();
        if (url.toLowerCase().trim().startsWith(FILE_PREFIX)) {
            filename = url.substring(FILE_PREFIX.length());
        }
        return filename;
    }
}

