/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.schedule.CertificateImportScheduler;
import de.trustable.ca3s.core.security.provider.Ca3sBundleFactory;
import de.trustable.ca3s.core.security.provider.TimedRenewalCertMapHolder;
import de.trustable.ca3s.core.service.util.CAStatus;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class CertBundleScheduler {
    transient Logger LOG = LoggerFactory.getLogger(CertificateImportScheduler.class);
    @Autowired
    private CAConnectorConfigRepository caConfigRepo;
    @Autowired
    private CaConnectorAdapter caConnAd;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private TimedRenewalCertMapHolder timedRenewalCertMapHolder;

    @Scheduled(fixedDelay=60000L)
    public void retrieveCertificates() {
        for (CAConnectorConfig caConfigDao : this.caConfigRepo.findAll()) {
            if (!caConfigDao.isActive().booleanValue() || !caConfigDao.isDefaultCA().booleanValue()) continue;
            if (CAStatus.Active.equals((Object)this.caConnAd.getStatus(caConfigDao))) {
                if (this.timedRenewalCertMapHolder.getCertMap().getBundleFactory() != null) continue;
                this.timedRenewalCertMapHolder.getCertMap().setBundleFactory((BundleFactory)new Ca3sBundleFactory(caConfigDao, this.caConnAd, this.certUtil));
                this.LOG.info("Ca3sBundleFactory registered for TLS certificate poduction");
                continue;
            }
            this.LOG.info("CA default connector not active");
        }
    }
}

