/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.trustable.ca3s.core.domain.BPNMProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.PipelineAttribute;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="pipeline")
@NamedQueries(value={@NamedQuery(name="Pipeline.findByTypeUrl", query="SELECT p FROM Pipeline p WHERE p.type = :type and p.urlPart = :urlPart"), @NamedQuery(name="Pipeline.findByType", query="SELECT p FROM Pipeline p WHERE p.type = :type ")})
public class Pipeline
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Column(name="name", nullable=false)
    private String name;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private PipelineType type;
    @Column(name="url_part")
    private String urlPart;
    @Column(name="description")
    private String description;
    @Column(name="approval_required")
    private Boolean approvalRequired;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="pipeline")
    @JsonIgnoreProperties(value={"pipeline"})
    private Set<PipelineAttribute> pipelineAttributes = new HashSet();
    @ManyToOne
    @JsonIgnoreProperties(value={"pipelines", "secret"})
    private CAConnectorConfig caConnector;
    @ManyToOne
    @JsonIgnoreProperties(value={"pipelines", "secret"})
    private BPNMProcessInfo processInfo;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Pipeline name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PipelineType getType() {
        return this.type;
    }

    public Pipeline type(PipelineType type) {
        this.type = type;
        return this;
    }

    public void setType(PipelineType type) {
        this.type = type;
    }

    public String getUrlPart() {
        return this.urlPart;
    }

    public Pipeline urlPart(String urlPart) {
        this.urlPart = urlPart;
        return this;
    }

    public void setUrlPart(String urlPart) {
        this.urlPart = urlPart;
    }

    public String getDescription() {
        return this.description;
    }

    public Pipeline description(String description) {
        this.description = description;
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean isApprovalRequired() {
        return this.approvalRequired;
    }

    public Pipeline approvalRequired(Boolean approvalRequired) {
        this.approvalRequired = approvalRequired;
        return this;
    }

    public void setApprovalRequired(Boolean approvalRequired) {
        this.approvalRequired = approvalRequired;
    }

    public Set<PipelineAttribute> getPipelineAttributes() {
        return this.pipelineAttributes;
    }

    public Pipeline pipelineAttributes(Set<PipelineAttribute> pipelineAttributes) {
        this.pipelineAttributes = pipelineAttributes;
        return this;
    }

    public Pipeline addPipelineAttributes(PipelineAttribute pipelineAttribute) {
        this.pipelineAttributes.add(pipelineAttribute);
        pipelineAttribute.setPipeline(this);
        return this;
    }

    public Pipeline removePipelineAttributes(PipelineAttribute pipelineAttribute) {
        this.pipelineAttributes.remove(pipelineAttribute);
        pipelineAttribute.setPipeline(null);
        return this;
    }

    public void setPipelineAttributes(Set<PipelineAttribute> pipelineAttributes) {
        this.pipelineAttributes = pipelineAttributes;
    }

    public CAConnectorConfig getCaConnector() {
        return this.caConnector;
    }

    public Pipeline caConnector(CAConnectorConfig cAConnectorConfig) {
        this.caConnector = cAConnectorConfig;
        return this;
    }

    public void setCaConnector(CAConnectorConfig cAConnectorConfig) {
        this.caConnector = cAConnectorConfig;
    }

    public BPNMProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public Pipeline processInfo(BPNMProcessInfo bPNMProcessInfo) {
        this.processInfo = bPNMProcessInfo;
        return this;
    }

    public void setProcessInfo(BPNMProcessInfo bPNMProcessInfo) {
        this.processInfo = bPNMProcessInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pipeline)) {
            return false;
        }
        return this.id != null && this.id.equals(((Pipeline)o).id);
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return "Pipeline{id=" + this.getId() + ", name='" + this.getName() + "', type='" + this.getType() + "', urlPart='" + this.getUrlPart() + "', description='" + this.getDescription() + "', approvalRequired='" + this.isApprovalRequired() + "'}";
    }
}

