/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import de.trustable.ca3s.core.security.jwt.JWTConfigurer;
import de.trustable.ca3s.core.security.jwt.TokenProvider;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.web.filter.CorsFilter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Import(value={SecurityProblemSupport.class})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Value(value="${win-auth.ad-domain:}")
    private String adDomain;
    @Value(value="${win-auth.ad-server:}")
    private String adServer;
    @Value(value="${win-auth.service-principal:}")
    private String servicePrincipal;
    @Value(value="${win-auth.keytab-location:ca3s.keytab}")
    private String keytabLocation;
    @Value(value="${win-auth.ldap-search-base:}")
    private String ldapSearchBase;
    @Value(value="${win-auth.ldap-search-filter:(| (userPrincipalName={0}) (sAMAccountName={0}))}")
    private String ldapSearchFilter;
    private final TokenProvider tokenProvider;
    private final CorsFilter corsFilter;
    private final SecurityProblemSupport problemSupport;

    public SecurityConfiguration(TokenProvider tokenProvider, CorsFilter corsFilter, SecurityProblemSupport problemSupport) {
        this.tokenProvider = tokenProvider;
        this.corsFilter = corsFilter;
        this.problemSupport = problemSupport;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/app/**/*.{js,html}"})).antMatchers(new String[]{"/i18n/**"})).antMatchers(new String[]{"/content/**"})).antMatchers(new String[]{"/h2-console/**"})).antMatchers(new String[]{"/swagger-ui/index.html"})).antMatchers(new String[]{"/test/**"});
    }

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).addFilterBefore((Filter)this.corsFilter, UsernamePasswordAuthenticationFilter.class).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.problemSupport).accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).headers().contentSecurityPolicy("default-src 'self'; frame-src 'self' data:; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://storage.googleapis.com; style-src 'self' 'unsafe-inline'; img-src 'self' data:; font-src 'self' data:").and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().featurePolicy("geolocation 'none'; midi 'none'; sync-xhr 'none'; microphone 'none'; camera 'none'; magnetometer 'none'; gyroscope 'none'; speaker 'none'; fullscreen 'self'; payment 'none'").and().frameOptions().deny().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/api/authenticate"})).permitAll().antMatchers(new String[]{"/api/register"})).permitAll().antMatchers(new String[]{"/api/activate"})).permitAll().antMatchers(new String[]{"/api/account/reset-password/init"})).permitAll().antMatchers(new String[]{"/api/account/reset-password/finish"})).permitAll().antMatchers(new String[]{"/api/profile-info"})).permitAll().antMatchers(new String[]{"/api/cockpit/**"})).permitAll().antMatchers(new String[]{"/api/tasklist/**"})).permitAll().antMatchers(new String[]{"/api/engine/**"})).permitAll().antMatchers(new String[]{"/api/admin/**"})).permitAll().antMatchers(new String[]{"/api/executeProcess/**"})).permitAll().antMatchers(new String[]{"/ca3sScep/**"})).permitAll().antMatchers(new String[]{"/publicapi/**"})).permitAll().antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/api/administerRequest"})).hasAuthority("ROLE_RA").antMatchers(new String[]{"/api/administerCertificate"})).hasAuthority("ROLE_RA").antMatchers(new String[]{"/websocket/tracker"})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/websocket/**"})).permitAll().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/prometheus"})).permitAll().antMatchers(new String[]{"/management/**"})).hasAuthority("ROLE_ADMIN").and()).httpBasic().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private JWTConfigurer securityConfigurerAdapter() {
        return new JWTConfigurer(this.tokenProvider);
    }
}

